/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.callchain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.json.simple.JSONObject;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.configuration.dataset.impl.remote.RemoteDataSet;
import org.qubership.automation.itf.core.model.common.Named;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.dataset.DataSetList;
import org.qubership.automation.itf.core.model.dataset.IDataSet;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIDataSetLabel;
import org.qubership.automation.itf.ui.messages.objects.UIDataSetList;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UITypedObject;
import org.qubership.automation.itf.ui.messages.objects.wrap.UIWrapper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Transactional(readOnly=true)
@RestController
public class DSCallChainController
extends ControllerHelper {
    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/callchain/setDefaultDataset"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Dataset {{#datasetName}} with id {{#datasetId}} set as Default for CallChain id {{#callchainId}} in the project {{#projectUuid}}")
    public void setDefaultDataset(@RequestParam(value="id", defaultValue="0") String callchainId, @RequestParam(value="datasetName", required=false) String datasetName, @RequestParam(value="datasetId", required=false) String datasetId, @RequestParam(value="projectUuid") UUID projectUuid) {
        CallChain callChain = (CallChain)DSCallChainController.getManager(CallChain.class).getById((Object)callchainId);
        callChain.setDatasetId(datasetId == null || datasetId.isEmpty() ? datasetName : datasetId);
        callChain.store();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/getDefaultDataset"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Default Dataset for CallChain id {{#id}} in the project {{#projectUuid}}")
    public String getDefaultDataset(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        CallChain callChain = (CallChain)DSCallChainController.getManager(CallChain.class).getById((Object)id);
        DSCallChainController.throwExceptionIfNull((Storable)callChain, null, id, CallChain.class, "get default DataSet");
        JSONObject result = new JSONObject();
        result.put((Object)"datasetId", (Object)callChain.getDatasetId());
        return result.toJSONString();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/datasetlists"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Dataset Lists for CallChain id {{#id}} in the project {{#projectUuid}}")
    public UIWrapper<List<UIDataSetList>> getDataSetLists(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        CallChain callChain = (CallChain)DSCallChainController.getManager(CallChain.class).getById((Object)id);
        DSCallChainController.throwExceptionIfNull((Storable)callChain, null, id, CallChain.class, "get DataSet lists");
        Set compatibleDataSetLists = callChain.getCompatibleDataSetLists((Object)projectUuid);
        ArrayList result = Lists.newArrayListWithCapacity((int)compatibleDataSetLists.size());
        compatibleDataSetLists.stream().sorted(Comparator.comparing(Named::getName)).forEach(item -> result.add(new UIDataSetList((DataSetList)item)));
        return new UIWrapper<List<UIDataSetList>>(result);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/datasets"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Datasets for CallChain id {{#id}} in the project {{#projectUuid}}")
    public List<UIObject> getDataSetList(@RequestParam(value="parent", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        CallChain chain = (CallChain)DSCallChainController.getManager(CallChain.class).getById((Object)id);
        DSCallChainController.throwExceptionIfNull((Storable)chain, "", id, CallChain.class, "get DataSets");
        Set dataSetLists = chain.getCompatibleDataSetLists((Object)projectUuid);
        if (dataSetLists != null) {
            LinkedList response = Lists.newLinkedList();
            for (DataSetList dataSetList : dataSetLists) {
                Set dataSets;
                try {
                    dataSets = dataSetList.getDataSets((Object)projectUuid);
                }
                catch (Exception e) {
                    continue;
                }
                for (IDataSet dataSet : dataSets) {
                    dataSet.addModifiedToName(false);
                    UITypedObject uiTypedObject = new UITypedObject();
                    uiTypedObject.setName(dataSet.getName());
                    uiTypedObject.setType(dataSetList.getName());
                    uiTypedObject.setClassName(dataSet.getClass().getName());
                    if (dataSet instanceof RemoteDataSet) {
                        uiTypedObject.setId(dataSet.getIdDs());
                    }
                    response.add(uiTypedObject);
                }
            }
            return response;
        }
        return Collections.emptyList();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/getDatasetsLabels"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Datasets' Labels for CallChain id {{#id}} in the project {{#projectUuid}}")
    public List<UIDataSetLabel> getDataSetLabels(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        CallChain chain = (CallChain)CoreObjectManager.getInstance().getManager(CallChain.class).getById((Object)id);
        DSCallChainController.throwExceptionIfNull((Storable)chain, "", id, CallChain.class, "get DataSet labels");
        Set dataSetLists = chain.getCompatibleDataSetLists((Object)projectUuid);
        if (dataSetLists != null) {
            HashSet uniqueListOfDataSetLabels = new HashSet();
            LinkedList result = Lists.newLinkedList();
            for (DataSetList dataSetList : dataSetLists) {
                Set dataSets;
                try {
                    dataSets = dataSetList.getDataSets((Object)projectUuid);
                }
                catch (Exception e) {
                    continue;
                }
                for (IDataSet dataSet : dataSets) {
                    if (!(dataSet instanceof RemoteDataSet)) continue;
                    uniqueListOfDataSetLabels.addAll(dataSet.getLabels());
                }
            }
            for (String label : uniqueListOfDataSetLabels) {
                UIDataSetLabel uiDataSetLabel = new UIDataSetLabel();
                uiDataSetLabel.setName(label);
                result.add(uiDataSetLabel);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

