/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.project;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.qubership.atp.auth.springbootstarter.entities.Operation;
import org.qubership.atp.auth.springbootstarter.entities.Project;
import org.qubership.atp.auth.springbootstarter.security.permissions.PolicyEnforcement;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.project.ProjectSettings;
import org.qubership.automation.itf.core.util.descriptor.ProjectSettingsDescriptor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.integration.users.AtpUsersService;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIConfig;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIStubProject;
import org.qubership.automation.itf.ui.messages.objects.transport.UIConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.qubership.automation.itf.ui.messages.properties.UIProjectSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Transactional
@RestController
@CrossOrigin
public class ProjectController
extends AbstractController<UIStubProject, StubProject> {
    private final ProjectSettingsDescriptor projectSettings;
    private final AtpUsersService atpUsersService;
    @Lazy
    private final PolicyEnforcement policyEnforcement;
    private final ProjectSettingsService projectSettingsService;
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean isMultiTenant;
    @Value(value="${spring.profiles.active}")
    private String springProfile;

    @Autowired
    public ProjectController(ProjectSettingsDescriptor projectSettings, AtpUsersService atpUsersService, PolicyEnforcement policyEnforcement, ProjectSettingsService projectSettingsService) {
        this.projectSettings = projectSettings;
        this.atpUsersService = atpUsersService;
        this.policyEnforcement = policyEnforcement;
        this.projectSettingsService = projectSettingsService;
    }

    @Override
    @Transactional(readOnly=true)
    @RequestMapping(value={"/project/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Projects list")
    public List<UIStubProject> getAll() {
        Collection<StubProject> projects = this.getProjects();
        if ("disable-security".equals(this.springProfile)) {
            return projects.stream().map(UIStubProject::new).collect(Collectors.toList());
        }
        Map projectsFromUserService = this.atpUsersService.getAllProjects().stream().collect(Collectors.toMap(Project::getUuid, Function.identity()));
        return projects.stream().filter(project -> {
            if (this.policyEnforcement.isAdmin() || this.policyEnforcement.isSupport()) {
                return true;
            }
            if (projectsFromUserService.containsKey(project.getUuid())) {
                return this.policyEnforcement.checkPoliciesForOperation((Project)projectsFromUserService.get(project.getUuid()), Operation.READ);
            }
            return false;
        }).map(UIStubProject::new).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(@securityHelper.getCurrentProjectUuid(#id), \"READ\")")
    @RequestMapping(value={"/project"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Project by id {{#id}}")
    public UIStubProject getById(@RequestParam(value="id") BigInteger id) {
        return (UIStubProject)super.getById(id.toString());
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/project/uuid/{uuid}"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Project by uuid {{#uuid}}")
    public UIStubProject getByUuid(@PathVariable String uuid) {
        SearchManager manager = (SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class);
        BigInteger projectId = manager.getEntityInternalIdByUuid(UUID.fromString(uuid));
        if (projectId == null) {
            LOGGER.error("Can't find project by uuid '{}'. Empty object is returned.", (Object)uuid);
            return new UIStubProject();
        }
        return new UIStubProject((StubProject)manager.getById((Object)projectId));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"CREATE\")")
    @RequestMapping(value={"/project"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Project with id {{#uiObject.id}} and uuid {{#projectUuid}}")
    public UIObject create(@RequestBody UIObject uiObject, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        StubProject stubProject = (StubProject)this.manager().create(this._getParent(null), this._getGenericUClass().getSimpleName(), this.projectSettings.asMapWithDefaultValues());
        stubProject.setName(uiObject.getName());
        LOGGER.info("Project {} is created", (Object)stubProject);
        return this._newInstanceTClass(stubProject);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/project"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Project with id {{#uiProject.id}} and uuid {{#projectUuid}}")
    public UIStubProject update(@RequestParam(value="projectUuid") UUID projectUuid, @RequestBody UIStubProject uiProject) {
        return super.update(uiProject);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"DELETE\")")
    @RequestMapping(value={"/project"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete Project with id {{#id}} and uuid {{#projectUuid}}")
    public void delete(@RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="id", defaultValue="0") String id) {
        StubProject stubProject = (StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)id);
        ControllerHelper.throwExceptionIfNull((Storable)stubProject, "", id, StubProject.class, "delete project");
        LOGGER.info("Project {} will be deleted now...", (Object)stubProject);
        stubProject.remove();
        LOGGER.info("Project {} is deleted", (Object)stubProject);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/project/settings/get"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Settings of Project by id {{#projectId}} and uuid {{#projectUuid}}")
    public UIConfiguration getAllProjectSettings(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        UIProjectSettings uiProjectSettings = new UIProjectSettings(new ProjectSettings(this.projectSettingsService.getAll((Object)projectId)));
        uiProjectSettings.setId(projectId.toString());
        uiProjectSettings.setClassName(StubProject.class.getName());
        return uiProjectSettings;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/project/setting/get"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Setting of Project by property {{#property}} and id {{#projectId}} and uuid {{#projectUuid}}")
    public UIConfig getProjectSetting(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="property") String property, @RequestParam(value="projectUuid") UUID projectUuid) {
        return new UIConfig(property, this.projectSettingsService.get((Object)projectId, property));
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/project/settings/update"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Settings of Project by id {{#projectId}}")
    public void updateProjectSettings(@RequestParam(value="projectId") String projectId, @RequestParam(value="projectUuid") UUID projectUuid, @RequestBody UIProjectSettings properties) {
        StubProject project = (StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)projectId);
        project.setName(properties.getName());
        Map currentSettings = this.projectSettingsService.getAll((Object)projectId);
        for (UIProperty uiProperty : properties.getProperties()) {
            currentSettings.put(uiProperty.getName(), uiProperty.getValue());
        }
        this.projectSettingsService.fillCache(project, currentSettings);
        project.setStorableProp(currentSettings);
        project.store();
    }

    @Override
    protected Class<StubProject> _getGenericUClass() {
        return StubProject.class;
    }

    @Override
    protected UIStubProject _newInstanceTClass(StubProject object) {
        return new UIStubProject(object);
    }

    @Override
    protected Storable _getParent(String parentId) {
        return null;
    }

    private Collection<StubProject> getProjects() {
        ArrayList<StubProject> allTenantProjectsList = new ArrayList<StubProject>();
        if (this.isMultiTenant.booleanValue()) {
            for (String tenantId : TenantContext.getTenantIds((boolean)false)) {
                TenantContext.setTenantInfo((String)tenantId);
                Collection allProjectsList = this.manager().getAll();
                allTenantProjectsList.addAll(allProjectsList);
            }
            TenantContext.setDefaultTenantInfo();
        }
        allTenantProjectsList.addAll(this.manager().getAll());
        return allTenantProjectsList;
    }
}

