/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.situation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.configuration.ConfigurationException;
import org.qubership.automation.itf.core.exceptions.operation.OperationException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.BvCaseContainingObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.LabeledObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SituationObjectManager;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.engine.EngineControlIntegration;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.core.util.registry.EngineIntegrationRegistry;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.entities.util.SituationControllerHelper;
import org.qubership.automation.itf.ui.controls.execute.ExecutorControllerHelper;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.UIListImpl;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIParsingRule;
import org.qubership.automation.itf.ui.messages.objects.UISituation;
import org.qubership.automation.itf.ui.messages.objects.UISituationExtended;
import org.qubership.automation.itf.ui.util.UIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SituationController
extends AbstractController<UISituation, Situation> {
    private static final Logger log = LoggerFactory.getLogger(SituationController.class);
    private SituationController self;

    @Autowired
    public void setSelf(SituationController self) {
        this.self = self;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Situations under Operation by id {{#parentId}} in the project {{#projectUuid}}")
    public UIListImpl getSituations(@RequestParam(value="parent", defaultValue="0") String parentId, @RequestParam(value="isFull", defaultValue="true") boolean isFull, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        if ("0".equals(parentId)) {
            Collection idNamePairCollection = ((SituationObjectManager)CoreObjectManager.getInstance().getSpecialManager(Situation.class, SituationObjectManager.class)).findAllByProjectIdOfNameAndId((Object)projectId);
            UIListImpl uiSituationUIList = new UIListImpl();
            LinkedList uiSituations = Lists.newLinkedList();
            for (IdNamePair entry : idNamePairCollection) {
                uiSituations.add(new UISituation(entry.getId(), entry.getName()));
            }
            uiSituationUIList.setObjects(uiSituations);
            return uiSituationUIList;
        }
        Operation operation = (Operation)CoreObjectManager.getInstance().getManager(Operation.class).getById((Object)parentId);
        ControllerHelper.throwExceptionIfNull((Storable)operation, "", parentId, Operation.class, "get Situations under Operation");
        Set situations = operation.getSituations();
        if (!isFull) {
            return UIHelper.getObjectList(situations);
        }
        UIListImpl uiSituationUIList = new UIListImpl();
        LinkedList uiSituations = Lists.newLinkedList();
        for (Situation entry : situations) {
            uiSituations.add(new UISituation(entry, false));
        }
        uiSituationUIList.setObjects(uiSituations);
        return uiSituationUIList;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Situation by id {{#id}} in the project {{#projectUuid}}")
    public UISituation getById(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return (UISituation)super.getById(id);
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/situation/{id}"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Situation by id {{#id}} via feign")
    public UISituation feignGetById(@PathVariable(value="id") String id) {
        return (UISituation)super.getById(id);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'CREATE')")
    @RequestMapping(value={"/situation"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Situation under Operation with id {{#parentId}} in the project {{#projectUuid}}")
    public UISituation create(@RequestParam(value="operation", defaultValue="0") String parentId, @RequestParam(value="projectUuid") UUID projectUuid, @RequestBody UISituation uiAddSituationReq) throws Exception {
        Operation operation = (Operation)ControllerHelper.getManager(Operation.class).getById((Object)parentId);
        ControllerHelper.throwExceptionIfNull((Storable)operation, "", parentId, Operation.class, "create Situation under Operation");
        UISituation emptyUISituation = (UISituation)super.create(parentId);
        if (uiAddSituationReq == null || StringUtils.isBlank((CharSequence)uiAddSituationReq.getName())) {
            return emptyUISituation;
        }
        Situation situation = (Situation)ControllerHelper.getManager(Situation.class).getById((Object)emptyUISituation.getId());
        situation.setName(uiAddSituationReq.getName());
        SituationControllerHelper.fillSituation(uiAddSituationReq, situation, operation);
        situation.store();
        return new UISituation(situation);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'CREATE') and @entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'CREATE')")
    @RequestMapping(value={"/createTemplateAndSituation"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Template and Situation under Operation with id {{#id}} in the project {{#projectUuid}}")
    public UISituation createTemplateAndSituation(@RequestParam(value="operation", defaultValue="0") String id, @RequestBody UISituationExtended uiAddSituationReq, @RequestParam(value="projectUuid") UUID projectUuid) {
        Operation operation = (Operation)ControllerHelper.getManager(Operation.class).getById((Object)id);
        ControllerHelper.throwExceptionIfNull((Storable)operation, "", id, Operation.class, "create Template and Situation under Operation");
        Situation situation = (Situation)ControllerHelper.getManager(Situation.class).create((Storable)operation);
        situation.setName(uiAddSituationReq.getUiSituation().getName());
        UIObject uiObject = uiAddSituationReq.getUiSituation().getTemplate();
        if (uiObject.getId() == null) {
            OperationTemplate template = (OperationTemplate)CoreObjectManager.getInstance().getManager(OperationTemplate.class).create((Storable)operation);
            template.setName(uiAddSituationReq.getUiSituation().getTemplate().getName());
            template.setText(uiAddSituationReq.getContent());
            uiObject.setId(template.getID().toString());
        }
        SituationControllerHelper.fillSituation(uiAddSituationReq.getUiSituation(), situation, operation);
        situation.store();
        return new UISituation(situation);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/situation"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Situation with id {{#uiSituation.id}} in the project {{#projectUuid}}")
    public UISituation update(@RequestBody UISituation uiSituation, @RequestParam(value="projectUuid") UUID projectUuid) {
        this.self._update(uiSituation);
        return this.self.refresh(uiSituation);
    }

    @Transactional
    public void _update(UISituation uiSituation) {
        super.update(uiSituation);
    }

    @Transactional(readOnly=true)
    public UISituation refresh(UISituation uiSituation) {
        Situation updatedSituation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)uiSituation.getId());
        return new UISituation(updatedSituation);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/scripts"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Scripts of the Situation with id {{#id}} in the project {{#projectUuid}}")
    public String[] getScripts(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new ConfigurationException("Empty situation id is given. Situation must be stored first!");
        }
        Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)id);
        ControllerHelper.throwExceptionIfNull((Storable)situation, "", id, Situation.class, "get Scripts under Situation");
        String[] result = new String[]{situation.getPreScript(), situation.getPostScript(), situation.getPreValidationScript()};
        return result;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'DELETE')")
    @RequestMapping(value={"/situation"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete Situations from Project {{#projectId}}/{{#projectUuid}}")
    public List<UIObject> delete(@RequestBody UIIds uiDeleteObjectReq, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        ObjectManager situationManager = CoreObjectManager.getInstance().getManager(Situation.class);
        ArrayList<Situation> situations = new ArrayList<Situation>();
        for (String situationId : uiDeleteObjectReq.getIds()) {
            Situation situation = (Situation)situationManager.getById((Object)situationId);
            if (situation == null) continue;
            Collection usages = situationManager.findUsages((Storable)situation);
            this.interruptIfSituationHasUsages(situation, usages);
            situations.add(situation);
        }
        ArrayList<UIObject> uiDeletedObjects = new ArrayList<UIObject>();
        for (Situation situation : situations) {
            uiDeletedObjects.add(new UIObject((Storable)situation));
            situation.getParent().getSituations().remove(situation);
            super.delete(situation);
            log.info("Situation is deleted: {}", (Object)situation);
        }
        return uiDeletedObjects;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'CREATE')")
    @RequestMapping(value={"/situation/integration/bv"}, method={RequestMethod.GET}, produces={"text/plain"})
    @AuditAction(auditAction="Create BVCase with bvLink {{#bvTcId}} on Situation with id {{#situationId}} in the project {{#projectId}}")
    public String createBvCaseOnSituation(@RequestParam(value="situationId") String situationId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="bvTcId", required=false) String bvTcId, @RequestParam(value="projectUuid") UUID projectUuid) throws IOException {
        if (StringUtils.isBlank((CharSequence)situationId)) {
            throw new ConfigurationException("Empty situation id is given. Situation must be stored first!");
        }
        Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)situationId);
        ControllerHelper.throwExceptionIfNull((Storable)situation, "", situationId, Situation.class, "get BV Test Case");
        EngineControlIntegration engine = (EngineControlIntegration)EngineIntegrationRegistry.getInstance().find("Bulk Validator Integration");
        if (engine != null) {
            IntegrationConfig integrationConf = ExecutorControllerHelper.findIntegrationConfig("Bulk Validator Integration", projectId);
            if (integrationConf != null) {
                if (bvTcId == null) {
                    engine.create(situation, integrationConf, projectId);
                } else {
                    situation.setBvTestcase(bvTcId);
                    if (!engine.isExist((Storable)situation, integrationConf, null, projectId)) {
                        throw new ConfigurationException("BV Test Case with ID '\" + bvTcId + \"' isn't found");
                    }
                }
                return situation.getBvTestcase();
            }
            throw new ConfigurationException("Bulk Validator Integration config isn't found for the project!\nPlease check 'Integration Configurations' and configure BV integration.");
        }
        throw new ConfigurationException("Bulk Validator Integration Engine isn't found in the registry!");
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'DELETE')")
    @RequestMapping(value={"/situation/integration/bv"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete or unlink BVCase on Situation with id {{#situationId}} in the project {{#projectId}} / {{#projectUuid}}")
    public void deleteOrUnlinkBvCaseOnSituation(@RequestParam(value="situationId") String situationId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="isDeleting") Boolean isDeleting, @RequestParam(value="projectUuid") UUID projectUuid) throws IOException {
        IntegrationConfig bvConfig;
        Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)situationId);
        ControllerHelper.throwExceptionIfNull((Storable)situation, "", situationId, Situation.class, "get situation by id");
        if (isDeleting.booleanValue() && ((BvCaseContainingObjectManager)CoreObjectManager.getInstance().getSpecialManager(Situation.class, BvCaseContainingObjectManager.class)).countBvCaseUsages(situation.getBvTestcase()) == 1 && (bvConfig = ExecutorControllerHelper.findIntegrationConfig("Bulk Validator Integration", projectId)) != null) {
            EngineControlIntegration engine = (EngineControlIntegration)EngineIntegrationRegistry.getInstance().find("Bulk Validator Integration");
            engine.delete(situation, bvConfig, projectId);
        }
        situation.setBvTestcase("");
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/getSituationsWithBvLinks"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Situations with BvLinks in the project {{#projectId}}/{{#projectUuid}}")
    public List<Object[]> getSituationsWithBvLinks(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return ((BvCaseContainingObjectManager)CoreObjectManager.getInstance().getSpecialManager(Situation.class, BvCaseContainingObjectManager.class)).getObjectsWithBvLinks(projectId);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/parsingRules"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get ParsingRules for Situation by id {{#id}} in the project {{#projectUuid}}")
    public Set<UIParsingRule> getParsingRules(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        HashSet result = Sets.newHashSet();
        Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)id);
        ControllerHelper.throwExceptionIfNull((Storable)situation, "", id, Situation.class, "get Parsing Rules under Situation");
        Set parsingRules = situation.getParsingRules();
        if (parsingRules != null) {
            for (ParsingRule parsingRule : parsingRules) {
                UIParsingRule uiParsingRule = new UIParsingRule((ParsingRule<? extends ParsingRuleProvider>)parsingRule);
                result.add(uiParsingRule);
            }
        }
        return result;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/label"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Situation Labels in the project {{#projectId}}/{{#projectUuid}}")
    public Set<String> getLabels(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return ((LabeledObjectManager)CoreObjectManager.getInstance().getSpecialManager(Situation.class, LabeledObjectManager.class)).getAllLabels(projectId);
    }

    @Override
    protected Situation _beforeUpdate(UISituation uiSituation, Situation situation) {
        IntegrationStep integrationStep = situation.getIntegrationStep();
        if (integrationStep == null) {
            integrationStep = (IntegrationStep)ControllerHelper.getManager(IntegrationStep.class).create((Storable)situation, "integrationStep");
        }
        if (this.stepParamsAreDifferent(uiSituation.getReceiver(), (Storable)integrationStep.getReceiver())) {
            integrationStep.setReceiver(uiSituation.getReceiver() != null ? (System)ControllerHelper.getManager(System.class).getById((Object)uiSituation.getReceiver().getId()) : null);
        }
        if (this.stepParamsAreDifferent(uiSituation.getOperation(), (Storable)integrationStep.getOperation())) {
            integrationStep.setOperation(uiSituation.getOperation() != null ? (Operation)ControllerHelper.getManager(Operation.class).getById((Object)uiSituation.getOperation().getId()) : null);
        }
        if (this.stepParamsAreDifferent(uiSituation.getTemplate(), (Storable)integrationStep.returnStepTemplate())) {
            integrationStep.setTemplate(uiSituation.getTemplate() != null ? TemplateHelper.getById((Object)uiSituation.getTemplate().getId()) : null);
        }
        integrationStep.setUnit(uiSituation.getUnit());
        integrationStep.setDelay(uiSituation.getDelay());
        if (uiSituation.getParsingRules() != null && uiSituation.getParsingRules().isLoaded()) {
            HashSet operationParsingRulesSet = Sets.newHashSetWithExpectedSize((int)100);
            for (UIParsingRule uiParsingRule : uiSituation.getParsingRules().getData()) {
                OperationParsingRule parsingRule = (OperationParsingRule)CoreObjectManager.getInstance().getManager(OperationParsingRule.class).getById((Object)uiParsingRule.getId());
                if (parsingRule == null) continue;
                ControllerHelper.validateParsingRule(uiParsingRule, (ParsingRule)parsingRule);
                parsingRule.setName(uiParsingRule.getName());
                parsingRule.fillProperties(uiParsingRule.getParamName(), uiParsingRule.getType(), uiParsingRule.getExpression(), uiParsingRule.getMultiple(), uiParsingRule.getAutosave());
                operationParsingRulesSet.add(parsingRule);
            }
            situation.setParsingRules((Set)operationParsingRulesSet);
        }
        if (uiSituation.getPreScript() != null && uiSituation.getPreScript().isLoaded()) {
            situation.setPreScript(uiSituation.getPreScript().getData());
        }
        if (uiSituation.getPostScript() != null && uiSituation.getPostScript().isLoaded()) {
            situation.setPostScript(uiSituation.getPostScript().getData());
        }
        if (uiSituation.getPreValidationScript() != null && uiSituation.getPreValidationScript().isLoaded()) {
            situation.setPreValidationScript(uiSituation.getPreValidationScript().getData());
        }
        return super._beforeUpdate(uiSituation, situation);
    }

    @Override
    protected Class<Situation> _getGenericUClass() {
        return Situation.class;
    }

    @Override
    protected UISituation _newInstanceTClass(Situation object) {
        return new UISituation(object);
    }

    @Override
    protected Storable _getParent(String parentId) {
        return ControllerHelper.getManager(Operation.class).getById((Object)parentId);
    }

    private boolean stepParamsAreDifferent(UIObject newParamValue, Storable oldParamValue) {
        if (newParamValue == null) {
            return oldParamValue != null;
        }
        if (oldParamValue == null) {
            return true;
        }
        return !newParamValue.getId().equals(oldParamValue.getID().toString());
    }

    private void interruptIfSituationHasUsages(Situation situation, Collection<UsageInfo> usages) {
        if (Objects.isNull(usages) || usages.isEmpty()) {
            return;
        }
        throw new OperationException("Delete Situation", String.format("Situation [name: '%s', id: '%s'] is used on callChain step(s) and/or on situation event trigger(s).\n Please find usages of this situation (use UI button 'Usages' on situation) and remove trigger(s) and(or) callChain step(s) first", situation.getName(), situation.getID()));
    }

    @Override
    protected void checkVersion(Situation object, UISituation uiObject) {
    }
}

