/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.system;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.common.ObjectNotFoundException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SystemObjectManager;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.message.delete.DeleteEntityResultMessage;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.constants.SystemMode;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.KeyDefinitionProvider;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.entities.util.KeyDefinitionControllerHelper;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIECIObject;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UISituation;
import org.qubership.automation.itf.ui.messages.objects.UISystem;
import org.qubership.automation.itf.ui.messages.objects.environment.UIEnvironment;
import org.qubership.automation.itf.ui.messages.objects.parents.UIIdentifiedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SystemController
extends AbstractController<UISystem, System> {
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/system/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Systems for project {{#projectId}}/{{#projectUuid}}")
    public List<? extends UIECIObject> getAll(@RequestParam(value="projectUuid") UUID projectUuid, @RequestParam BigInteger projectId) {
        Collection systems = ((SystemObjectManager)CoreObjectManager.getInstance().getSpecialManager(System.class, SystemObjectManager.class)).getByProjectId(projectId);
        ArrayList<UIECIObject> uiEciObjects = new ArrayList<UIECIObject>();
        for (System system : systems) {
            uiEciObjects.add(new UIECIObject((Storable)system));
        }
        return uiEciObjects;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/system/allSimple"}, method={RequestMethod.GET})
    public List<IdNamePair> getAllSimple(@RequestParam(value="projectUuid") UUID projectUuid, @RequestParam BigInteger projectId) {
        return ((SystemObjectManager)CoreObjectManager.getInstance().getSpecialManager(System.class, SystemObjectManager.class)).getSimpleListByProject((Object)projectId);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/system/allbyparent"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Systems by parent id {{#parentId}} for project {{#projectUuid}}")
    public List<? extends UIObject> getAll(@RequestParam(value="parentId", defaultValue="0") String parentId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return this.getUiObjectsBySystems(parentId);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/system"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get System by id {{#id}} for project {{#projectUuid}}")
    public UISystem getById(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return (UISystem)super.getById(id);
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/system/{id}"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get System by id {{#id}} using feign")
    public UISystem feignGetById(@PathVariable(value="id") String id) {
        return (UISystem)super.getById(id);
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/systems"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Systems for project {{#projectUuid}}")
    public Collection<UIIdentifiedObject> getSystemsByProjectId(@RequestParam UUID projectId) {
        BigInteger internalProjectId = ((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectId);
        if (Objects.isNull(internalProjectId)) {
            throw new ObjectNotFoundException("Project", projectId.toString(), null, "get Systems under project");
        }
        Collection systems = ((SystemObjectManager)CoreObjectManager.getInstance().getSpecialManager(System.class, SystemObjectManager.class)).getByProjectId(internalProjectId);
        String className = System.class.getName();
        return systems.stream().map(system -> {
            UIIdentifiedObject uiIdentifiedObject = new UIIdentifiedObject();
            uiIdentifiedObject.setId(system.getID().toString());
            uiIdentifiedObject.setName(system.getName());
            uiIdentifiedObject.setClassName(className);
            return uiIdentifiedObject;
        }).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/system/{id}/operations"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Outbound Operations from System with id {{#id}}")
    public Collection<UIIdentifiedObject> getOutOperationsBySystem(@PathVariable BigInteger id) {
        System system = (System)CoreObjectManager.getInstance().getManager(System.class).getById((Object)id);
        ControllerHelper.throwExceptionIfNull((Storable)system, null, String.valueOf(id), System.class, "get Operations under System");
        return this.getOperationsBySystemAndDirection(system, true);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"CREATE\")")
    @RequestMapping(value={"/system"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create System under parent id {{#parentId}} in the project {{#projectUuid}}")
    public UIObject create(@RequestParam(value="id", defaultValue="0") String parentId, @RequestParam(value="projectUuid") UUID projectUuid, @RequestBody UIObject requestBody) {
        if (requestBody == null) {
            return super.create(parentId);
        }
        return super.create(parentId, requestBody.getName(), "system", requestBody.getDescription(), (List<String>)requestBody.getLabels());
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"DELETE\")")
    @RequestMapping(value={"/system"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @AuditAction(auditAction="Delete Systems from project {{#projectId}}/{{#projectUuid}}")
    public DeleteEntityResultMessage<String, UIObject> delete(@RequestParam(value="ignoreUsages", defaultValue="false") Boolean ignoreUsages, @RequestBody String deleteObjectsReq, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        HashMap systemsWithTriggers = new HashMap();
        HashMap<String, String> usingSystems = new HashMap<String, String>();
        ArrayList<String> idsOfSystemsToDelete = new ArrayList<String>();
        ArrayList<String> idsOfFoldersToDelete = new ArrayList<String>();
        ArrayList<System> systemsWithoutTriggers = new ArrayList<System>();
        JsonArray deleteObjects = ((JsonObject)ControllerHelper.GSON.fromJson(deleteObjectsReq, JsonObject.class)).getAsJsonArray("entitiesForDelete");
        for (int i = 0; i < deleteObjects.size(); ++i) {
            JsonObject entity = deleteObjects.get(i).getAsJsonObject();
            if (entity.get("isParent").getAsBoolean()) {
                idsOfFoldersToDelete.add(entity.get("id").getAsString());
                continue;
            }
            idsOfSystemsToDelete.add(entity.get("id").getAsString());
        }
        for (String id : idsOfSystemsToDelete) {
            System system = (System)ControllerHelper.getManager(System.class).getById((Object)id);
            ArrayList<UIObject> triggers = new ArrayList<UIObject>();
            Map blockingTriggers = ControllerHelper.getManager(System.class).findImportantChildren((Storable)system);
            if (blockingTriggers != null && !blockingTriggers.isEmpty()) {
                UIObject uiObject;
                if (blockingTriggers.containsKey("SituationEventTriggers")) {
                    for (BigInteger triggerId : (List)blockingTriggers.get("SituationEventTriggers")) {
                        uiObject = new UIObject();
                        uiObject.setId(triggerId.toString());
                        uiObject.setClassName("SituationEventTrigger");
                        triggers.add(uiObject);
                    }
                }
                if (blockingTriggers.containsKey("TransportTriggers")) {
                    for (BigInteger triggerId : (List)blockingTriggers.get("TransportTriggers")) {
                        uiObject = new UIObject();
                        uiObject.setId(triggerId.toString());
                        uiObject.setClassName("TransportTrigger");
                        triggers.add(uiObject);
                    }
                }
            }
            if (!triggers.isEmpty()) {
                systemsWithTriggers.put(system.getID().toString(), triggers);
                continue;
            }
            systemsWithoutTriggers.add(system);
        }
        for (System system : systemsWithoutTriggers) {
            Collection usageInfo = ControllerHelper.getManager(System.class).remove((Storable)system, ignoreUsages.booleanValue());
            if (usageInfo != null) {
                usingSystems.put(system.getID().toString(), this.usageInfoListAsString(usageInfo));
                continue;
            }
            ((SystemFolder)ControllerHelper.getManager(SystemFolder.class).getById(system.getParent().getID())).getObjects().remove(system);
        }
        for (String id : idsOfFoldersToDelete) {
            SystemFolder folder = (SystemFolder)ControllerHelper.getManager(SystemFolder.class).getById((Object)id);
            if (Objects.nonNull(folder) && folder.getObjects().isEmpty() && folder.getSubFolders().isEmpty()) {
                ControllerHelper.getManager(SystemFolder.class).remove((Storable)folder, ignoreUsages.booleanValue());
                continue;
            }
            usingSystems.put(folder.getID().toString(), "Folder '" + folder.getName() + "' contains subfolders and/or systems.");
        }
        return new DeleteEntityResultMessage(systemsWithTriggers, usingSystems);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/system"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update System with id {{#uiSystem.id}} in the project {{#projectUuid}}")
    public UISystem update(@RequestBody UISystem uiSystem, @RequestParam(value="projectUuid") UUID projectUuid) {
        return super.update(uiSystem);
    }

    @Override
    public Class<System> _getGenericUClass() {
        return System.class;
    }

    @Override
    public UISystem _newInstanceTClass(System object) {
        return new UISystem(object);
    }

    @Override
    public Storable _getParent(String parentId) {
        return ControllerHelper.getManager(Folder.class).getById((Object)parentId);
    }

    @Override
    public System _beforeUpdate(UISystem uiObject, System object) {
        SystemMode mode = SystemMode.fromString((String)uiObject.getMode());
        object.setMode(mode == null ? SystemMode.STUB : mode);
        if (uiObject.getOperationDefinition() != null && uiObject.getOperationDefinition().isLoaded()) {
            object.setOperationKeyDefinition(uiObject.getOperationDefinition().getData());
        }
        try {
            KeyDefinitionControllerHelper.editContextKeyDefinition((KeyDefinitionProvider)object, uiObject.getIncoming(), uiObject.getOutgoing());
        }
        catch (Exception e) {
            log.error("Edit ContextKeyDefinition is failed", (Throwable)e);
        }
        return object;
    }

    @Override
    public void _deleteSubObjects(System object) {
        HashMap result = Maps.newHashMap();
        boolean isSafe = this.haveUsages(object, result, false);
        Set templates = object.returnTemplates();
        for (Template temp : templates) {
            temp.remove();
        }
        Set operations = object.getOperations();
        for (Operation op : operations) {
            for (Template temp : op.returnTemplates()) {
                temp.remove();
            }
        }
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/system/usages"}, method={RequestMethod.GET}, produces={"application/json"})
    @AuditAction(auditAction="Get usages of the System with id {{#id}} in the project {{#projectUuid}}")
    public Map<String, Object> getUsages(@RequestParam(value="id") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        ObjectManager<System> systemManager = ControllerHelper.getManager(System.class);
        System system = (System)systemManager.getById((Object)id);
        Collection usageInfo = systemManager.findUsages((Storable)system);
        HashMap<String, Object> usages = new HashMap<String, Object>();
        ArrayList<UIObject> usage = new ArrayList<UIObject>();
        if (usageInfo != null) {
            for (UsageInfo item : usageInfo) {
                if (item.getReferer() instanceof Environment) {
                    Environment env = (Environment)item.getReferer();
                    usage.add(new UIEnvironment(env));
                    continue;
                }
                if (item.getReferer().getParent() instanceof Situation) {
                    Situation situation = (Situation)item.getReferer().getParent();
                    usage.add(new UISituation(situation));
                    continue;
                }
                usage.add(new UIObject(item.getReferer()));
            }
            usages.put("usages", usage);
        }
        return usages;
    }

    private List<? extends UIObject> getUiObjectsBySystems(String parentId) {
        super.setSimple(true);
        List<UIObject> list = Strings.isNullOrEmpty((String)parentId) ? super.getAll() : super.getAll(parentId);
        super.setSimple(false);
        return list;
    }

    private Collection<UIIdentifiedObject> getOperationsBySystemAndDirection(System system, boolean isOutbound) {
        ArrayList<UIIdentifiedObject> toReturn = new ArrayList<UIIdentifiedObject>();
        String className = Operation.class.getName();
        for (Operation operation : system.getOperations()) {
            TransportConfiguration transport = operation.getTransport();
            if (transport == null || (!isOutbound || !transport.getMep().isOutbound()) && (isOutbound || !transport.getMep().isInbound())) continue;
            UIIdentifiedObject uiIdentifiedObject = new UIIdentifiedObject();
            uiIdentifiedObject.setId(operation.getID().toString());
            uiIdentifiedObject.setName(operation.getName());
            uiIdentifiedObject.setClassName(className);
            toReturn.add(uiIdentifiedObject);
        }
        return toReturn;
    }

    @Override
    protected void checkVersion(System object, UISystem uiObject) {
    }
}

