/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.template;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang3.tuple.Triple;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.SystemParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.constants.Match;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.util.VelocityVariablesLexer;
import org.qubership.automation.itf.ui.util.VelocityVariablesParser;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional(readOnly=true)
public class TemplateDebugController
extends ControllerHelper {
    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/exists"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Get Templates by part of name '{{#name}}' in the project {{#projectId}}/{{#projectUuid}}")
    public ResponseEntity getByName(@RequestParam(value="name") String name, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return new ResponseEntity(TemplateHelper.getByPieceOfNameAndProject((String)name, (BigInteger)projectId).isEmpty() ? HttpStatus.NOT_FOUND : HttpStatus.OK);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/parameters"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Get parameters of the Template with id {{#id}} in the project {{#projectId}}/{{#projectUuid}}")
    public String getTemplateParameters(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectId") BigInteger projectId, @RequestBody String editRequest, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        Template template = TemplateHelper.getById((Object)id);
        TemplateDebugController.throwExceptionIfNull((Storable)template, "", id, Template.class, "get Template parameters");
        String templateContent = Strings.isNullOrEmpty((String)editRequest.replace("{", "").replace("}", "")) ? template.getText() : editRequest;
        JSONObject result = this.extractVelocityVariables(template, templateContent, projectId);
        return result.toJSONString();
    }

    private JSONObject extractVelocityVariables(Template template, String templateContent, BigInteger projectId) {
        System parentSystem;
        ObjectManager parsingRuleObjectManager;
        VelocityVariablesLexer lexer = new VelocityVariablesLexer((CharStream)new ANTLRInputStream(templateContent));
        VelocityVariablesParser parser = new VelocityVariablesParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        VelocityVariablesParser.VariablesContext templateContext = parser.variables();
        JSONObject result = new JSONObject();
        JSONArray variables = new JSONArray();
        TemplateProvider templateParent = template.getParent();
        HashMap<String, String> parentsMap = new HashMap<String, String>();
        if (templateParent instanceof System) {
            parsingRuleObjectManager = CoreObjectManager.getInstance().getManager(SystemParsingRule.class);
            parentSystem = (System)templateParent;
            parentsMap.put(parentSystem.getName(), "System");
            for (Operation operation : parentSystem.getOperations()) {
                if (operation.returnParsingRules().size() <= 0) continue;
                parentsMap.put(operation.getName(), "Operation");
            }
        } else {
            parsingRuleObjectManager = CoreObjectManager.getInstance().getManager(OperationParsingRule.class);
            parentsMap.put(templateParent.getName(), "Operation");
            parentSystem = templateParent.getParent();
            if (parentSystem instanceof System) {
                parentsMap.put(parentSystem.getName(), "System");
            }
        }
        for (String variable : templateContext.variablesList) {
            String escapedName = variable.replace("$", "").replace("!", "").replace("{", "").replace("}", "");
            boolean isParsingRule = escapedName.startsWith("tc.saved.") || escapedName.startsWith("sp.");
            boolean isStepRule = false;
            if ((escapedName = escapedName.replace("tc.saved.", "")).startsWith("sp.")) {
                escapedName = escapedName.substring(3);
                isStepRule = true;
            }
            String parentsStr = isParsingRule ? this.getParsingRuleParents(projectId, escapedName, parentsMap, isStepRule, (ObjectManager<? extends ParsingRule<? extends ParsingRuleProvider>>)parsingRuleObjectManager) : null;
            JSONObject variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)variable);
            variableJson.put((Object)"value", (Object)"");
            if (isParsingRule && !Strings.isNullOrEmpty((String)parentsStr)) {
                variableJson.put((Object)"source", (Object)"PARSING RULE");
                variableJson.put((Object)"parents", (Object)parentsStr);
            }
            variables.add((Object)variableJson);
        }
        result.put((Object)"variables", (Object)variables);
        return result;
    }

    private String getParsingRuleParents(BigInteger projectId, String ruleName, Map<String, String> parentObjectNames, boolean isStepRule, ObjectManager<? extends ParsingRule<? extends ParsingRuleProvider>> parsingRuleObjectManager) {
        Collection parsingRules = parsingRuleObjectManager.getByProperties(projectId, new Triple[]{Triple.of((Object)"name", (Object)Match.EQUALS, (Object)ruleName)});
        if (parsingRules == null) {
            return null;
        }
        ArrayList<String> parentNames = new ArrayList<String>();
        ArrayList<String> directParentNames = new ArrayList<String>();
        for (ParsingRule parsingRule : parsingRules) {
            String ruleParentName = parsingRule.getParent().getName();
            if (isStepRule) {
                if (!parentObjectNames.containsKey(ruleParentName)) continue;
                directParentNames.add(String.format("%s: %s", parentObjectNames.get(ruleParentName), ruleParentName));
                continue;
            }
            if (parentObjectNames.containsKey(ruleParentName)) {
                directParentNames.add(String.format("%s: %s", parentObjectNames.get(ruleParentName), ruleParentName));
                continue;
            }
            String parentType = parsingRule.getParent() instanceof System ? "System" : "Operation";
            parentNames.add(String.format("%s: %s", parentType, ruleParentName));
        }
        if (parentNames.isEmpty() && directParentNames.isEmpty()) {
            return null;
        }
        return Joiner.on((String)",\n").join(directParentNames.isEmpty() ? parentNames : directParentNames);
    }
}

