/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.util;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.util.eds.service.FileManagementService;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationControllerHelper {
    private static final String INPUT_TYPE_REFERENCE = "reference";
    @Autowired
    private FileManagementService fileManagementService;

    public void setProperty(Configuration entry, UIProperty property, UUID projectUuid) {
        if (INPUT_TYPE_REFERENCE.equals(property.getInputType())) {
            if (property.getReferenceValue() != null) {
                entry.put(property.getName(), property.getReferenceValue().getId());
            } else {
                entry.put(property.getName(), "");
            }
        } else {
            String propertyValue = StringUtils.isNotEmpty((CharSequence)property.getValue()) && StringUtils.isNotEmpty((CharSequence)property.getFilePathDirectoryType()) ? this.fileManagementService.getDirectory(property.getFilePathDirectoryType(), projectUuid, property.getValue()) : property.getValue();
            entry.put(property.getName(), propertyValue);
        }
    }
}

