/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.util;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Objects;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerSyncActivationRequest;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.Pair;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.qubership.automation.itf.core.util.provider.TriggerProvider;
import org.qubership.automation.itf.ui.controls.entities.EventTriggerController;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIOperation;
import org.qubership.automation.itf.ui.messages.objects.UISituation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SituationControllerHelper
extends ControllerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SituationControllerHelper.class);

    public static EventTriggerSyncActivationRequest synchronizeSituations(UIOperation uiOperation, Operation operation) {
        EventTriggerSyncActivationRequest activationRequest = new EventTriggerSyncActivationRequest();
        if (uiOperation.getSituations() != null && uiOperation.getSituations().isLoaded()) {
            Collection situationsToDelete = Collections2.filter((Collection)operation.getSituations(), situation -> {
                for (UISituation uiSituation : uiOperation.getSituations().getData()) {
                    if (uiSituation.getId() == null || !uiSituation.getId().equals(Objects.toString(situation.getID()))) continue;
                    return false;
                }
                return true;
            });
            for (Object situation2 : situationsToDelete) {
                situation2.remove();
            }
            Lists.newArrayList((Iterable)situationsToDelete).forEach(operation.getSituations()::remove);
            Collection situationsToAdd = Collections2.filter((Collection)Lists.newArrayList((Iterable)uiOperation.getSituations().getData()), uiSituation -> Strings.isNullOrEmpty((String)uiSituation.getId()));
            for (UISituation uiSituation2 : situationsToAdd) {
                Situation situation3 = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).create((Storable)operation);
                SituationControllerHelper.fillSituation(uiSituation2, situation3, operation);
            }
            Collection situationsToModify = Collections2.filter((Collection)Lists.newArrayList((Iterable)uiOperation.getSituations().getData()), input -> !Strings.isNullOrEmpty((String)input.getId()));
            for (UISituation uiSituation3 : situationsToModify) {
                Situation situation4 = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)uiSituation3.getId());
                if (situation4 != null) {
                    activationRequest.merge(SituationControllerHelper.fillSituation(uiSituation3, situation4, operation));
                    continue;
                }
                LOGGER.warn("Situation not found by id {}; skipped", (Object)uiSituation3.getId());
            }
        }
        return activationRequest;
    }

    public static EventTriggerSyncActivationRequest fillSituation(UISituation uiSituation, Situation situation, Operation parent) {
        situation.setName(uiSituation.getName());
        situation.setDescription(uiSituation.getDescription());
        situation.fillLabels(uiSituation.getLabels());
        situation.setIgnoreErrors(uiSituation.isIgnoreErrors());
        if (uiSituation.getKeysToRegenerate() != null) {
            situation.getKeysToRegenerate().clear();
            for (Pair<String, String> regenerationKey : uiSituation.getKeysToRegenerate()) {
                situation.addKeyToRegenerate((String)regenerationKey.getKey(), (String)regenerationKey.getValue());
            }
        }
        situation.setValidateIncoming(uiSituation.getValidateIncoming());
        situation.setBvTestcase(uiSituation.getBvTestcase());
        if (uiSituation.getTemplate() != null && !Strings.isNullOrEmpty((String)uiSituation.getTemplate().getId())) {
            IntegrationStep step = situation.getIntegrationStep() != null ? situation.getIntegrationStep() : (IntegrationStep)CoreObjectManager.getInstance().getManager(IntegrationStep.class).create((Storable)situation, "integrationStep");
            step.setSender(parent.getParent());
            if (uiSituation.getReceiver() != null && !Strings.isNullOrEmpty((String)uiSituation.getReceiver().getId())) {
                String uiReceiverId = uiSituation.getReceiver().getId();
                if (step.getReceiver() == null || !uiReceiverId.equals(String.valueOf(step.getReceiver().getID()))) {
                    step.setReceiver((System)CoreObjectManager.getInstance().getManager(System.class).getById((Object)uiReceiverId));
                }
            } else {
                step.setReceiver(null);
            }
            if (parent.getMep().isOutbound() && parent.getMep().isRequest() || Mep.INBOUND_REQUEST_RESPONSE_SYNCHRONOUS.equals((Object)parent.getMep())) {
                step.setOperation(parent);
            } else if (uiSituation.getOperation() != null) {
                String uiOperationId = uiSituation.getOperation().getId();
                if (step.getOperation() == null || !uiOperationId.equals(String.valueOf(step.getOperation().getID()))) {
                    step.setOperation((Operation)CoreObjectManager.getInstance().getManager(Operation.class).getById((Object)uiOperationId));
                }
            } else {
                step.setOperation(null);
            }
            UIObject uiTemplate = uiSituation.getTemplate();
            if (uiTemplate != null && SituationControllerHelper.templateNullOrDifferent(uiTemplate, (Template<? extends TemplateProvider>)step.returnStepTemplate())) {
                step.setTemplate(TemplateHelper.getById((Object)uiTemplate.getId(), uiTemplate.getParent() == null ? null : uiTemplate.getParent().getClassName()));
            }
            step.setName(String.format("%s sends %s to %s with template %s", ControllerHelper.getName((Storable)step.getSender()), ControllerHelper.getName((Storable)step.getOperation()), ControllerHelper.getName((Storable)step.getReceiver()), ControllerHelper.getName((Storable)step.returnStepTemplate())));
            step.setDelay(uiSituation.getDelay());
            step.setUnit(uiSituation.getUnit());
        } else if (situation.getIntegrationStep() != null) {
            IntegrationStep integrationStep = situation.getIntegrationStep();
            situation.getSteps().remove(integrationStep);
            integrationStep.remove();
        }
        EventTriggerSyncActivationRequest activationRequest = EventTriggerController.synchronizeTriggers(uiSituation.getTriggers() == null ? Sets.newHashSet() : Sets.newHashSet(uiSituation.getTriggers()), (TriggerProvider)situation);
        if (parent.getMep().isInboundRequest() && !situation.getOperationEventTriggers().isEmpty()) {
            ((OperationEventTrigger)situation.getOperationEventTriggers().iterator().next()).setPriority(uiSituation.getPriority());
        }
        return activationRequest;
    }

    private static boolean templateNullOrDifferent(UIObject uiTemplate, Template<? extends TemplateProvider> stepTemplate) {
        if (stepTemplate == null) {
            return true;
        }
        return !uiTemplate.getId().equals(String.valueOf(stepTemplate.getID()));
    }
}

