/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service;

import java.io.IOException;
import java.util.Map;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
public class SseController {
    private static final Logger log = LoggerFactory.getLogger(SseController.class);
    private final Map<String, SseEmitter> sseEmitters;
    @Value(value="${atp-itf-executor.sse-timeout}")
    private Long sseEmitterTimeout;
    @Value(value="${atp-itf-executor.sse-reconnect-time}")
    private Long sseReconnectTime;

    @Autowired
    public SseController(Map<String, SseEmitter> sseEmitters) {
        this.sseEmitters = sseEmitters;
    }

    @CrossOrigin
    @GetMapping(path={"/sse/connect"}, produces={"text/event-stream"})
    @AuditAction(auditAction="Handle connection for session {{#sessionId}}")
    public SseEmitter handle(@RequestParam String sessionId) throws IOException {
        SseEmitter emitter = new SseEmitter(this.sseEmitterTimeout);
        this.sseEmitters.put(sessionId, emitter);
        emitter.onCompletion(() -> {
            this.sseEmitters.remove(sessionId);
            log.info("Remove the completed event emitter with sessionId:{}", (Object)sessionId);
        });
        emitter.onTimeout(() -> {
            this.sseEmitters.remove(sessionId);
            log.info("Remove event emitter on timeout with sessionId:{}", (Object)sessionId);
        });
        emitter.onError(ex -> log.info("SseEmitter with sessionId:{} got error:{}", (Object)sessionId, ex));
        SseEmitter.SseEventBuilder sseEvent = SseEmitter.event().id(sessionId).name("init").data((Object)"{\"message\":\"init sse connection...\"}").reconnectTime(this.sseReconnectTime.longValue());
        emitter.send(sseEvent);
        log.info("Connection successfully established with sessionId:{}", (Object)sessionId);
        return emitter;
    }
}

