/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.tree;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.common.NotValidValueException;
import org.qubership.automation.itf.core.exceptions.common.ObjectNotFoundException;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.FolderManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.LabeledObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.CallChainObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.tree.AbstractTreeBuilder;
import org.qubership.automation.itf.ui.controls.tree.TreeController;
import org.qubership.automation.itf.ui.controls.util.ControllerConstants;
import org.qubership.automation.itf.ui.messages.objects.UITreeElement;
import org.qubership.automation.itf.ui.messages.tree.UITreeData;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional(readOnly=true)
public class CallChainTreeController
extends AbstractTreeBuilder<CallChain, Folder>
implements TreeController {
    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/folder"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get CallChain Tree under Folder id {{#id}} in the project {{#projectUuid}}")
    public UITreeData getTree(@RequestParam(required=false) String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return this.getTree(id);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/tree/node"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get CallChain Tree for current id {{#id}} or parent id {{#parentId}} in the project {{#projectUuid}}")
    public UITreeData getTreeFromNode(@RequestParam(required=false) String id, @RequestParam(required=false) String parentId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return StringUtils.isBlank((CharSequence)id) ? this.getTree(parentId) : this.buildTree(this.getCallChainOrFolder(id));
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/tree/node/name"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get CallChain Tree for node by name {{#value}} and parent id {{#parentId}} in the project {{#projectId}}/{{#projectUuid}}")
    public UITreeData getTreeFromNodeByName(@RequestParam(required=false) String value, @RequestParam(required=false) String[] filters, @RequestParam(required=false) String parentId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return this.getTree(parentId);
        }
        HashSet nodes = Sets.newHashSetWithExpectedSize((int)ControllerConstants.DEFAULT_OBJECTS_COUNT_FOUND_BY_NAME.getIntValue());
        String[] stringArray = filters;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String filter;
            switch (filter = stringArray[i]) {
                case "NAME": {
                    nodes.addAll(this.getCallChainAndFolderByName(value, projectId));
                    continue block8;
                }
                case "LABEL": {
                    nodes.addAll(this.getAllLabeledByPieceOfName(value.toLowerCase(), this.getCallChainAndFolderByName("", projectId)));
                    continue block8;
                }
            }
        }
        return this.buildTreeByFilter(nodes);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/label"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all CallChain Labels in the project {{#projectId}}/{{#projectUuid}}")
    public Set<String> gelLabels(@RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="projectId") BigInteger projectId) {
        return ((LabeledObjectManager)CoreObjectManager.getInstance().getSpecialManager(CallChain.class, LabeledObjectManager.class)).getAllLabels(projectId);
    }

    @Override
    UITreeElement fillFolder(Storable storable) {
        Folder folder = (Folder)storable;
        UITreeElement currentFolder = new UITreeElement();
        this.configureObject(currentFolder, (Storable)folder);
        this.addSubElements(currentFolder, folder.getSubFolders());
        this.addSubElements(currentFolder, folder.getObjects());
        return currentFolder;
    }

    @Override
    Class<Folder> getParentClass() {
        return Folder.class;
    }

    @Override
    Class<CallChain> getChildClass() {
        return CallChain.class;
    }

    private UITreeData getTree(String id) {
        Folder<CallChain> folder = this.getFolderByIdOrRootIfNull(id);
        UITreeData treeData = new UITreeData();
        UITreeElement currentFolder = this.fillFolder((Storable)folder);
        treeData.setTreeData(currentFolder.getChildren());
        return treeData;
    }

    @Nonnull
    private Folder<CallChain> getFolderByIdOrRootIfNull(@Nullable String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new NotValidValueException("Folder id cannot be null");
        }
        return (Folder)CoreObjectManager.getInstance().getManager(Folder.class).getById((Object)id);
    }

    private Storable getCallChainOrFolder(@RequestParam String id) {
        Storable node = CoreObjectManager.getInstance().getManager(CallChain.class).getById((Object)id);
        if (node == null) {
            node = CoreObjectManager.getInstance().getManager(Folder.class).getById((Object)id);
        }
        if (node == null) {
            throw new ObjectNotFoundException("Call chain or Call Chain folder", id, null, null);
        }
        return node;
    }

    private Collection<Storable> getCallChainAndFolderByName(String name, BigInteger projectId) {
        HashSet nodes = Sets.newHashSetWithExpectedSize((int)ControllerConstants.DEFAULT_OBJECTS_COUNT_FOUND_BY_NAME.getIntValue());
        nodes.addAll(((CallChainObjectManager)CoreObjectManager.getInstance().getSpecialManager(CallChain.class, CallChainObjectManager.class)).getByPieceOfNameAndProjectId(name, projectId));
        nodes.addAll(((FolderManager)CoreObjectManager.getInstance().getSpecialManager(Folder.class, FolderManager.class)).findFolderByPieceOfName("ChainFolder", name, projectId));
        return nodes;
    }
}

