/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.tree;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.common.ObjectNotFoundException;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.FolderManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.LabeledObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SystemObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.tree.AbstractTreeBuilder;
import org.qubership.automation.itf.ui.controls.tree.TreeController;
import org.qubership.automation.itf.ui.controls.util.ControllerConstants;
import org.qubership.automation.itf.ui.messages.objects.UITreeElement;
import org.qubership.automation.itf.ui.messages.tree.UITreeData;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional(readOnly=true)
public class SystemTreeController
extends AbstractTreeBuilder<System, Folder>
implements TreeController {
    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/system/folder"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get System Tree under Folder id {{#id}} in the project {{#projectUuid}}")
    public UITreeData getTree(@RequestParam(required=false) String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return this.getTree(id);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/system/tree/node"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get System Tree for current id {{#id}} or parent id {{#parentId}} in the project {{#projectUuid}}")
    public UITreeData getTreeFromNode(String id, String parentId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return StringUtils.isBlank((CharSequence)id) ? this.getTree(parentId) : this.buildTree(this.getSystemOrFolder(id));
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/system/tree/node/name"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get System Tree for node by name {{#value}} and parent id {{#parentId}} in the project {{#projectId}}/{{#projectUuid}}")
    public UITreeData getTreeFromNodeByName(@RequestParam(required=false) String value, @RequestParam(required=false) String[] filters, @RequestParam(required=false) String parentId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return this.getTree(parentId);
        }
        HashSet nodes = Sets.newHashSetWithExpectedSize((int)5);
        String[] stringArray = filters;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String filter;
            switch (filter = stringArray[i]) {
                case "NAME": {
                    nodes.addAll(this.getSystemAndFolderByName(value, projectId));
                    continue block8;
                }
                case "LABEL": {
                    nodes.addAll(this.getAllLabeledByPieceOfName(value.toLowerCase(), this.getSystemAndFolderByName("", projectId)));
                    continue block8;
                }
            }
        }
        return this.buildTreeByFilter(nodes);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/system/label"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all System Labels in the project {{#projectId}}/{{#projectUuid}}")
    public Set<String> gelLabels(@RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="projectId") BigInteger projectId) {
        return ((LabeledObjectManager)CoreObjectManager.getInstance().getSpecialManager(System.class, LabeledObjectManager.class)).getAllLabels(projectId);
    }

    private UITreeData getTree(String id) {
        Folder<System> folder = this.getFolderByIdOrRootIfNull(id);
        UITreeData treeData = new UITreeData();
        UITreeElement currentFolder = this.fillFolder((Storable)folder);
        treeData.setTreeData(currentFolder.getChildren());
        return treeData;
    }

    private Collection<Storable> getSystemAndFolderByName(String name, BigInteger projectId) {
        HashSet nodes = Sets.newHashSetWithExpectedSize((int)ControllerConstants.DEFAULT_OBJECTS_COUNT_FOUND_BY_NAME.getIntValue());
        nodes.addAll(((SystemObjectManager)CoreObjectManager.getInstance().getSpecialManager(System.class, SystemObjectManager.class)).getByPieceOfNameAndProject(name, (Object)projectId));
        nodes.addAll(((FolderManager)CoreObjectManager.getInstance().getSpecialManager(Folder.class, FolderManager.class)).findFolderByPieceOfName("SystemFolder", name, projectId));
        return nodes;
    }

    @Nonnull
    private Folder<System> getFolderByIdOrRootIfNull(@Nullable String id) {
        return (Folder)CoreObjectManager.getInstance().getManager(Folder.class).getById((Object)id);
    }

    @Override
    UITreeElement fillFolder(Storable nodeProvider) {
        UITreeElement currentFolder = new UITreeElement();
        Folder folder = (Folder)nodeProvider;
        this.configureObject(currentFolder, (Storable)folder);
        this.addSubElements(currentFolder, folder.getSubFolders());
        this.addSubElements(currentFolder, folder.getObjects());
        return currentFolder;
    }

    @Override
    Class<Folder> getParentClass() {
        return Folder.class;
    }

    @Override
    Class<System> getChildClass() {
        return System.class;
    }

    private Storable getSystemOrFolder(@RequestParam String id) {
        Storable node = CoreObjectManager.getInstance().getManager(System.class).getById((Object)id);
        if (node == null) {
            node = CoreObjectManager.getInstance().getManager(Folder.class).getById((Object)id);
        }
        if (node == null) {
            throw new ObjectNotFoundException("System or System folder", id, null, null);
        }
        return node;
    }
}

