/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.tree;

import java.util.Collection;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.ui.messages.objects.UITreeElement;
import org.qubership.automation.itf.ui.messages.tree.UITreeData;

public interface TreeBuilder {
    public UITreeData buildTree(Storable var1);

    default public void configureObject(UITreeElement treeElement, Storable storable) {
        if (storable == null) {
            return;
        }
        treeElement.setId(storable.getID().toString());
        treeElement.setName(storable.getName());
        treeElement.setDescription(storable.getDescription());
        if (storable instanceof LabeledStorable) {
            treeElement.setLabels(((LabeledStorable)storable).getLabels());
        }
        treeElement.setClassName(storable.getClass().getName());
        treeElement.setIsFolder(storable instanceof Folder);
    }

    default public <T extends Storable> void addSubElements(UITreeElement currentFolder, Collection<T> objects) {
        for (Storable storable : objects) {
            UITreeElement object = new UITreeElement();
            this.configureObject(object, storable);
            if (storable instanceof Folder) {
                object.setIsFolder(true);
            }
            if (currentFolder.getChildren().contains(object)) continue;
            currentFolder.addChild(object);
        }
    }
}

