/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.ui.controls.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceRegenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceRegenerator.class);

    public static void regenerateSystems(Set<System> targetSystems, HashMap<System, System> systemsToReplacementMap) {
        HashMap<String, HashMap<String, Situation>> situationReplacementsOnSituationTriggers = Collector.collectSituationsFromSystemsMap(systemsToReplacementMap);
        Map<String, Template> templateReplacements = Collector.collectTemplatesFromSystems(systemsToReplacementMap.values());
        for (System targetSystem : targetSystems) {
            Map<String, Operation> operationReplacements = Collector.collectOperationsFromSystem(targetSystem);
            for (Operation o : targetSystem.getOperations()) {
                for (Situation situation : o.getSituations()) {
                    String templateId;
                    String operationId;
                    IntegrationStep step = situation.getIntegrationStep();
                    if (step == null) continue;
                    LOGGER.info("Regenerating operations for" + step.toString());
                    if (step.getOperation() != null && operationReplacements.containsKey(operationId = step.getOperation().getID().toString())) {
                        step.setOperation(operationReplacements.get(operationId));
                    }
                    LOGGER.info("Regenerating sender for" + step.toString());
                    if (step.getSender() != null && systemsToReplacementMap.containsKey(step.getSender())) {
                        step.setSender(systemsToReplacementMap.get(step.getSender()));
                    }
                    LOGGER.info("Regenerating receiver for" + step.toString());
                    if (step.getReceiver() != null && systemsToReplacementMap.containsKey(step.getReceiver())) {
                        step.setReceiver(systemsToReplacementMap.get(step.getReceiver()));
                    }
                    LOGGER.info("Regenerating templates for" + step.toString());
                    if (step.returnStepTemplate() != null && templateReplacements.containsKey(templateId = step.returnStepTemplate().getID().toString())) {
                        step.setTemplate(templateReplacements.get(templateId));
                    }
                    LOGGER.info("Regenerating start-/finish-situations under triggers on situation for" + step.toString());
                    if (situation.getSituationEventTriggers().size() <= 0) continue;
                    for (SituationEventTrigger trigger : situation.getSituationEventTriggers()) {
                        if (trigger.getSituation() == null) continue;
                        trigger.setSituation(ReferenceRegenerator.getSituationReplacementIfExists(trigger.getSituation(), situationReplacementsOnSituationTriggers));
                    }
                }
            }
        }
    }

    public static Set<SituationStep> regenerateSituationSteps(HashMap<System, System> systems, Set<SituationStep> situationSteps) {
        HashMap<String, HashMap<String, Situation>> situationsReplacementsOnSituationSteps = Collector.collectSituationsFromSystemsMap(systems);
        for (SituationStep step : situationSteps) {
            if (step.getSituation() != null) {
                step.setSituation(ReferenceRegenerator.getSituationReplacementIfExists(step.getSituation(), situationsReplacementsOnSituationSteps));
            }
            if (step.getEndSituations() != null && !step.getEndSituations().isEmpty()) {
                HashSet<Situation> endSituationReplacements = new HashSet<Situation>();
                for (Situation endSituation : step.getEndSituations()) {
                    if (endSituation == null) continue;
                    endSituationReplacements.add(ReferenceRegenerator.getSituationReplacementIfExists(endSituation, situationsReplacementsOnSituationSteps));
                }
                step.setEndSituations(endSituationReplacements);
            }
            if (step.getExceptionalSituations() == null || step.getExceptionalSituations().isEmpty()) continue;
            HashSet<Situation> exceptionalSituationReplacements = new HashSet<Situation>();
            for (Situation exceptionalSituation : step.getExceptionalSituations()) {
                if (exceptionalSituation == null) continue;
                exceptionalSituationReplacements.add(ReferenceRegenerator.getSituationReplacementIfExists(exceptionalSituation, situationsReplacementsOnSituationSteps));
            }
            step.setExceptionalSituations(exceptionalSituationReplacements);
        }
        return situationSteps;
    }

    private static Situation getSituationReplacementIfExists(Situation targetSituation, HashMap<String, HashMap<String, Situation>> situationReplacements) {
        String systemKey = targetSituation.getParent().getParent().getID().toString();
        String replacementKey = targetSituation.getID().toString();
        if (situationReplacements.containsKey(systemKey) && situationReplacements.get(systemKey).containsKey(replacementKey)) {
            return situationReplacements.get(systemKey).get(replacementKey);
        }
        return targetSituation;
    }
}

