/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.integration.ec.UIECIConfiguration;

public class UITreeElement
extends UIECIConfiguration {
    private UIObject folder;
    private boolean isFolder;
    private boolean isRoot;
    private boolean expanded;
    private String inboundState;
    private Collection<UITreeElement> children = Sets.newHashSetWithExpectedSize((int)50);

    public UITreeElement() {
    }

    public UITreeElement(Storable storable) {
        super(storable);
        if (this.getParent() != null) {
            this.setFolder(this.getParent());
        }
        if (storable instanceof Folder) {
            this.setIsFolder(true);
        }
    }

    public UITreeElement(UIObject uiObject, boolean isFolder) {
        super(uiObject);
        if (this.getParent() != null) {
            this.setFolder(this.getParent());
        }
        this.setIsFolder(isFolder);
    }

    public UITreeElement(UITreeElement uiObject) {
        super(uiObject);
        if (uiObject.getFolder() != null) {
            this.setFolder(new UIObject(uiObject.getFolder()));
        } else if (this.getParent() != null) {
            this.setFolder(this.getParent());
        }
        if (uiObject.getIsFolder()) {
            this.setIsFolder(true);
        }
    }

    public UITreeElement(UITreeElement uiObject, Collection<UITreeElement> children, Class<? extends Storable> clazz) {
        this.setName(uiObject.getName());
        this.setId(uiObject.getId());
        if (!clazz.getName().equals(uiObject.getClassName())) {
            this.setIsFolder(true);
        }
        this.setDescription(uiObject.getDescription());
        this.setLabels((List<String>)uiObject.getLabels());
        this.setClassName(uiObject.getClassName());
        this.addListChildrenIfExists(children, clazz);
        this.setVersion(uiObject.getVersion());
    }

    @Override
    public void loadChildrenByClass(Class childClass, List<Storable> children) {
        ArrayList childrenByClass = Lists.newArrayList();
        for (UITreeElement uITreeElement : this.children) {
            if (!uITreeElement.getClassName().equals(childClass.getName())) continue;
            childrenByClass.add(uITreeElement);
        }
        if (!childrenByClass.isEmpty()) {
            children.retainAll(childrenByClass);
        }
        for (Storable storable : children) {
            this.addChild(new UITreeElement(storable));
        }
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean root) {
        this.isRoot = root;
    }

    public boolean getIsFolder() {
        return this.isFolder;
    }

    public void setIsFolder(boolean folder) {
        this.isFolder = folder;
    }

    public UIObject getFolder() {
        return this.folder;
    }

    public void setFolder(UIObject folder) {
        this.folder = folder;
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public void addChild(UITreeElement object) {
        this.children.add(object);
    }

    public Collection<UITreeElement> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<UITreeElement> children) {
        this.children = children;
    }

    public void addListChildrenIfExists(Collection<UITreeElement> objects, Class<? extends Storable> clazz) {
        for (UITreeElement object : objects) {
            if (object.getFolder() == null || !this.getId().equals(object.getFolder().getId())) continue;
            this.setParent(null);
            object.setIsFolder(true);
            this.addChild(new UITreeElement(object, objects, clazz));
        }
    }

    public String getInboundState() {
        return this.inboundState;
    }

    public void setInboundState(String inboundState) {
        this.inboundState = inboundState;
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && (obj == this || obj.hashCode() == this.hashCode());
    }
}

