/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.callchain.step;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.condition.ConditionsHelper;
import org.qubership.automation.itf.core.model.jpa.step.AbstractCallChainStep;
import org.qubership.automation.itf.core.util.Pair;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UITypedObject;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UIEmbeddedChainStep;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UISituationStep;
import org.qubership.automation.itf.ui.messages.objects.eventtrigger.UICondition;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=UIEmbeddedChainStep.class, name="embeddedChainStep"), @JsonSubTypes.Type(value=UISituationStep.class, name="situationStep")})
public abstract class UIAbstractCallChainStep
extends UITypedObject {
    private long delay;
    private String unit;
    private boolean enabled;
    private boolean manual;
    private List<Pair<String, String>> keysToRegenerate = Lists.newArrayList();
    private String stepName;
    private int conditionMaxAttempts;
    private long conditionMaxTime;
    private String conditionUnitMaxTime;
    private boolean conditionRetry;
    private List<UICondition> conditions;
    private String preScript;
    private int order;

    public UIAbstractCallChainStep() {
    }

    public UIAbstractCallChainStep(AbstractCallChainStep step) {
        super((Storable)step, true);
        this.fillUiAbstractCallChainStep(step, true);
    }

    public UIAbstractCallChainStep(AbstractCallChainStep step, boolean isFullWithParent) {
        super((Storable)step, isFullWithParent);
        this.fillUiAbstractCallChainStep(step, isFullWithParent);
    }

    private void fillUiAbstractCallChainStep(AbstractCallChainStep step, boolean isFullWithParent) {
        this.setOrder(step.getOrder());
        this.setDelay(step.getDelay());
        this.setUnit(step.getUnit());
        this.setEnabled(step.isEnabled());
        this.setManual(step.isManual());
        for (Map.Entry entry : step.getKeysToRegenerate().entrySet()) {
            this.keysToRegenerate.add((Pair<String, String>)new Pair(entry.getKey(), entry.getValue()));
        }
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getManual() {
        return this.manual;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }

    public void updateObject(AbstractCallChainStep step) {
        super.updateObject((Storable)step);
        step.setEnabled(this.getEnabled());
        step.setManual(this.getManual());
        step.setDelay(this.getDelay());
        step.setUnit(this.getUnit());
        step.getKeysToRegenerate().clear();
        if (this.keysToRegenerate != null) {
            for (Pair<String, String> regenerationKey : this.keysToRegenerate) {
                step.addKeyToRegenerate((String)regenerationKey.getKey(), (String)regenerationKey.getValue());
            }
        }
        step.setPreScript(this.getPreScript());
        this._updateStep(step);
    }

    public List<Pair<String, String>> getKeysToRegenerate() {
        return this.keysToRegenerate;
    }

    public void setKeysToRegenerate(List<Pair<String, String>> keysToRegenerate) {
        this.keysToRegenerate = keysToRegenerate;
    }

    public abstract void _updateStep(AbstractCallChainStep var1);

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public int getConditionMaxAttempts() {
        return this.conditionMaxAttempts;
    }

    public void setConditionMaxAttempts(int conditionMaxAttempts) {
        this.conditionMaxAttempts = conditionMaxAttempts;
    }

    public long getConditionMaxTime() {
        return this.conditionMaxTime;
    }

    public void setConditionMaxTime(long conditionMaxTime) {
        this.conditionMaxTime = conditionMaxTime;
    }

    public boolean isConditionRetry() {
        return this.conditionRetry;
    }

    public void setConditionRetry(boolean conditionRetry) {
        this.conditionRetry = conditionRetry;
    }

    public String getConditionUnitMaxTime() {
        return this.conditionUnitMaxTime;
    }

    public void setConditionUnitMaxTime(String conditionUnitMaxTime) {
        this.conditionUnitMaxTime = conditionUnitMaxTime;
    }

    public List<UICondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<UICondition> conditions) {
        this.conditions = conditions;
    }

    public String getPreScript() {
        return this.preScript;
    }

    public void setPreScript(String preScript) {
        this.preScript = preScript;
    }

    protected void processConditions(AbstractCallChainStep step) {
        if (this.getConditions() != null) {
            List conditionParameters = step.getConditionParameters() == null ? new ArrayList() : step.getConditionParameters();
            ConditionsHelper.fillConditionParameters(conditionParameters, ControllerHelper.toConditionParameters(this.getConditions()));
            step.setConditionParameters(conditionParameters);
        } else if (step.getConditionParameters() != null) {
            step.setConditionParameters(new ArrayList());
        }
    }

    protected void fillConditionsFromStep(AbstractCallChainStep step) {
        List conditionParameters = step.getConditionParameters();
        if (conditionParameters != null && !conditionParameters.isEmpty()) {
            List<UICondition> uiConditions = conditionParameters.stream().map(UICondition::new).sorted((c1, c2) -> c1.getOrderId() > c2.getOrderId() ? 1 : -1).collect(Collectors.toList());
            this.setConditions(uiConditions);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

