/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.environment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.manager.TriggerStateManager;
import org.qubership.automation.itf.ui.controls.entities.environment.EnvironmentController;
import org.qubership.automation.itf.ui.messages.objects.UIECIObject;
import org.qubership.automation.itf.ui.messages.objects.environment.UIEnvironmentItem;
import org.qubership.automation.itf.ui.messages.objects.transport.UIConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIEnvironment
extends UIECIObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIEnvironment.class);
    private ImmutableList<UIEnvironmentItem> outbound;
    private ImmutableList<UIEnvironmentItem> inbound;
    private ImmutableList<UIConfiguration> reportLinkCollectors;
    private String inboundState;

    public UIEnvironment() {
    }

    public UIEnvironment(EciConfigurable storable) {
        super((Storable)storable);
    }

    public UIEnvironment(Environment environment) {
        super((Storable)environment);
        this.setOutbound(this.convertTransportConfigToUI(environment, environment.getOutbound()));
        this.setInbound(this.convertTransportConfigToUI(environment, environment.getInbound()));
        TriggerState triggerState = environment.getEnvironmentState();
        if (triggerState == null) {
            triggerState = TriggerStateManager.getInstance().getInboundTriggersState(environment);
        }
        this.setInboundState(triggerState.toString());
    }

    private static UIEnvironmentItem createItem(Map.Entry<System, Server> entry) {
        Server server;
        UIEnvironmentItem item = new UIEnvironmentItem();
        System system = entry.getKey();
        if (system != null) {
            item.defineSystem(system);
        }
        if ((server = entry.getValue()) != null) {
            item.defineServer(server);
        }
        return item;
    }

    public ImmutableList<UIEnvironmentItem> getOutbound() {
        return this.outbound;
    }

    public void setOutbound(List<UIEnvironmentItem> outbound) {
        this.outbound = ImmutableList.copyOf(outbound);
    }

    public ImmutableList<UIEnvironmentItem> getInbound() {
        return this.inbound;
    }

    public void setInbound(List<UIEnvironmentItem> inbound) {
        this.inbound = ImmutableList.copyOf(inbound);
    }

    public ImmutableList<UIConfiguration> getReportLinkCollectors() {
        return this.reportLinkCollectors;
    }

    public void setReportLinkCollectors(List<UIConfiguration> reportLinkCollectors) {
        this.reportLinkCollectors = ImmutableList.copyOf(reportLinkCollectors);
    }

    public String getInboundState() {
        return this.inboundState;
    }

    public void setInboundState(String inboundState) {
        this.inboundState = inboundState;
    }

    private List<UIEnvironmentItem> convertTransportConfigToUI(Environment environment, Map<System, Server> systemServerMap) {
        ArrayList inbound = Lists.newArrayList();
        for (Map.Entry<System, Server> entryMap : systemServerMap.entrySet()) {
            try {
                inbound.add(UIEnvironment.createItem(entryMap));
            }
            catch (Exception e) {
                LoggerFactory.getLogger(EnvironmentController.class).error("Failed loading environment {}", (Object)environment.getName());
            }
        }
        return inbound;
    }
}

