/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.environment;

import java.util.Objects;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UISystem;
import org.qubership.automation.itf.ui.messages.objects.environment.UIServer;
import org.slf4j.LoggerFactory;

public class UIEnvironmentItem {
    private UIObject system;
    private UIObject server;

    public UIObject getSystem() {
        return this.system;
    }

    public void setSystem(UIObject system) {
        this.system = system;
    }

    public void defineSystem(System system) {
        this.system = this.getUiObject((Storable)system);
    }

    private UIObject getUiObject(Storable storable) {
        try {
            return new UIObject(storable);
        }
        catch (NullPointerException e) {
            LoggerFactory.getLogger(UIEnvironmentItem.class).error("Failed to getting UI Object from storable", (Throwable)e);
            return new UIObject();
        }
    }

    public void defineSystem(UISystem system) {
        this.system = new UIObject(system);
    }

    public UIObject getServer() {
        return this.server;
    }

    public void setServer(UIObject server) {
        this.server = server;
    }

    public void defineServer(Server server) {
        this.server = new UIServer(server);
    }

    public void defineServer(UIServer server) {
        this.server = new UIObject(server);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UIEnvironmentItem that = (UIEnvironmentItem)o;
        if (this.system == null && that.system != null || this.system != null && that.system == null || this.server == null && that.server != null || this.server != null && that.server == null) {
            return false;
        }
        return (this.system == null && that.system == null || this.system.getId().equals(that.system.getId())) && (this.server == null && that.server == null || this.server.getId().equals(that.server.getId()));
    }

    public int hashCode() {
        return Objects.hash(this.system, this.server);
    }
}

