/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.environment;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.rmi.RemoteException;
import java.util.Collection;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.environment.UIServer;
import org.qubership.automation.itf.ui.messages.objects.transport.UIInboundConfiguration;

public class UIServerInbound
extends UIServer {
    private static final Function<InboundTransportConfiguration, UIInboundConfiguration> TO_UI_INPUT_CONF = new Function<InboundTransportConfiguration, UIInboundConfiguration>(){

        public UIInboundConfiguration apply(InboundTransportConfiguration input) {
            UIInboundConfiguration uiConfiguration = new UIInboundConfiguration(input);
            try {
                uiConfiguration.defineProperties(input);
                uiConfiguration.defineTriggers(input.getTriggerConfigurations());
            }
            catch (RemoteException | TransportException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return uiConfiguration;
        }
    };
    private UIObject system;
    private ImmutableList<UIInboundConfiguration> configurations;

    public UIServerInbound() {
    }

    public UIServerInbound(Server storable) {
        super(storable);
        this.url = storable.getUrl();
    }

    public UIObject getSystem() {
        return this.system;
    }

    public void setSystem(UIObject system) {
        this.system = system;
    }

    public ImmutableList<UIInboundConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Collection<UIInboundConfiguration> configurations) {
        this.configurations = ImmutableList.copyOf(configurations);
    }

    public void defineSystem(System system) {
        this.system = new UIObject((Storable)system);
    }

    public void defineConfiguration(Collection<InboundTransportConfiguration> configurations) throws RemoteException {
        this.setConfigurations(Collections2.transform(configurations, TO_UI_INPUT_CONF));
    }
}

