/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.transport.interceptor;

import com.google.common.collect.Lists;
import java.util.List;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.transport.interceptor.UIApplicabilityParams;

public class UIApplicabilityParamsList {
    private List<UIApplicabilityParams> values = Lists.newArrayList();

    public List<UIApplicabilityParams> getValues() {
        return this.values;
    }

    public void setValues(List<UIApplicabilityParams> values) {
        this.values = values;
    }

    public UIResult validate() {
        UIResult result = this.fieldsAreNotEmpty();
        if (result.isSuccess()) {
            result = this.applicableParametersAreNotDuplicated();
        }
        return result;
    }

    private UIResult fieldsAreNotEmpty() {
        for (UIApplicabilityParams applicabilityParams : this.values) {
            if (applicabilityParams.getEnvironment() != null) continue;
            return new UIResult(false, "Environment can not be empty. Please, fill the parameters.");
        }
        return new UIResult();
    }

    private UIResult applicableParametersAreNotDuplicated() {
        for (int i = 0; i < this.values.size(); ++i) {
            for (int g = i + 1; g < this.values.size(); ++g) {
                String comparingSystemId;
                String sourceEnvId = this.values.get(i).getEnvironment().getId();
                String comparingEnvId = this.values.get(g).getEnvironment().getId();
                String sourceSystemId = this.values.get(i).getSystem() != null ? this.values.get(i).getSystem().getId() : "";
                String string = comparingSystemId = this.values.get(g).getSystem() != null ? this.values.get(g).getSystem().getId() : "";
                if (!sourceEnvId.equals(comparingEnvId) || !sourceSystemId.equals(comparingSystemId)) continue;
                return new UIResult(false, String.format("Applicability Parameters(Environment = %s, System = %s) already exist in interceptor.", this.values.get(i).getEnvironment().getName(), this.values.get(i).getSystem() != null ? this.values.get(i).getSystem().getName() : "empty"));
            }
        }
        return new UIResult();
    }
}

