/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.services;

import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.qubership.atp.auth.springbootstarter.entities.ServiceEntities;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.qubership.automation.itf.core.config.BeanAwareSpringLiquibase;
import org.qubership.automation.itf.ui.util.UserManagementEntities;

public class ServiceEntitiesMigrationCustomChange
implements CustomTaskChange {
    private static final UUID SERVICE_ENTITIES_ID = UUID.fromString("6f6b31a3-26f6-4cd7-ae9c-e335b215cb52");
    private String serviceName;

    public void execute(Database database) {
        ServiceEntities entities = new ServiceEntities();
        entities.setUuid(SERVICE_ENTITIES_ID);
        entities.setService(this.serviceName);
        entities.setEntities(Arrays.stream(UserManagementEntities.values()).map(UserManagementEntities::getName).collect(Collectors.toList()));
        UsersService usersService = (UsersService)BeanAwareSpringLiquibase.getBean(UsersService.class);
        usersService.sendEntities(entities);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

