/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.services.javers.history;

import com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.ObjectNotFoundException;
import org.javers.core.Javers;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.json.simple.JSONObject;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.EventTriggerBriefInfo;
import org.qubership.automation.itf.core.model.javers.history.HistoryAbstractConfiguration;
import org.qubership.automation.itf.core.model.javers.history.HistoryAbstractEventTrigger;
import org.qubership.automation.itf.core.model.javers.history.HistoryAbstractTemplate;
import org.qubership.automation.itf.core.model.javers.history.HistoryAbstractTestCase;
import org.qubership.automation.itf.core.model.javers.history.HistoryCallChain;
import org.qubership.automation.itf.core.model.javers.history.HistoryIdentified;
import org.qubership.automation.itf.core.model.javers.history.HistoryIntegrationConfig;
import org.qubership.automation.itf.core.model.javers.history.HistoryIntegrationStep;
import org.qubership.automation.itf.core.model.javers.history.HistoryLabeledStorable;
import org.qubership.automation.itf.core.model.javers.history.HistoryOperation;
import org.qubership.automation.itf.core.model.javers.history.HistoryOperationEventTrigger;
import org.qubership.automation.itf.core.model.javers.history.HistoryOperationTemplate;
import org.qubership.automation.itf.core.model.javers.history.HistoryOutboundTemplateTransportConfiguration;
import org.qubership.automation.itf.core.model.javers.history.HistorySituation;
import org.qubership.automation.itf.core.model.javers.history.HistorySituationEventTrigger;
import org.qubership.automation.itf.core.model.javers.history.HistoryStep;
import org.qubership.automation.itf.core.model.javers.history.HistorySystemTemplate;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.AbstractTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.step.AbstractStep;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTriggerImpl;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.template.OutboundTemplateTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.testcase.AbstractTestCase;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.executor.service.SecurityHelper;
import org.qubership.automation.itf.ui.services.javers.history.HistoryEntityHelper;
import org.qubership.automation.itf.ui.services.javers.history.HistoryRestoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HistoryRestoreService {
    private static final Logger log = LoggerFactory.getLogger(HistoryRestoreService.class);
    private static final ModelMapper modelMapper = new ModelMapper();
    private final Javers javers;
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private final ProjectSettingsService projectSettingsService;

    private static Converter<Set<BigInteger>, Set<? extends Storable>> referenceCollectionConverter(Class<? extends Storable> clazz) {
        return mappingContext -> ((Set)mappingContext.getSource()).stream().map(objectId -> {
            Storable storable = CoreObjectManager.getInstance().getManager(clazz).getById(objectId);
            if (Objects.isNull(storable)) {
                throw new ObjectNotFoundException((Serializable)objectId, mappingContext.getDestinationType().getSimpleName());
            }
            return storable;
        }).collect(Collectors.toSet());
    }

    private static Converter<Set<Object>, Set<? extends Storable>> referenceListConverter(Class<? extends Storable> clazz) {
        return mappingContext -> ((Set)mappingContext.getSource()).stream().map(id -> HistoryRestoreService.getReference(clazz, String.valueOf(id), storableId -> CoreObjectManager.getInstance().getManager(clazz).getById(storableId))).collect(Collectors.toSet());
    }

    private static Converter<HistorySituation, List<? extends Step>> integrationStepConverter() {
        return context -> {
            HistoryIntegrationStep historyIntegrationStep = ((HistorySituation)context.getSource()).getIntegrationStep();
            Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)((HistorySituation)context.getSource()).getId());
            if (historyIntegrationStep != null) {
                IntegrationStep integrationStep = situation.getIntegrationStep();
                if (integrationStep == null) {
                    throw new RuntimeException(String.format("Situation %s [id=%s] has no integration step. Object cannot be restored.", situation.getName(), situation.getID()));
                }
                modelMapper.map((Object)historyIntegrationStep, (Object)integrationStep);
            }
            return situation.getSteps();
        };
    }

    private static Converter<String, ? extends Storable> referenceConverter(Class<? extends Storable> clazz) {
        return mappingContext -> HistoryRestoreService.getReference(clazz, String.valueOf(mappingContext.getSource()), storableId -> CoreObjectManager.getInstance().getManager(clazz).getById(storableId));
    }

    private static Converter<String, ? extends Storable> referenceToTemplateConverter() {
        return mappingContext -> HistoryRestoreService.getReference(Template.class, String.valueOf(mappingContext.getSource()), TemplateHelper::getById);
    }

    private static Storable getReference(Class<? extends Storable> clazz, String id, Function<String, Storable> getStorable) {
        Storable reference = null;
        if (StringUtils.isNotBlank((CharSequence)id) && (reference = getStorable.apply(id)) == null) {
            throw new ObjectNotFoundException((Serializable)((Object)id), clazz.getSimpleName());
        }
        return reference;
    }

    private static Converter<Set<? extends HistoryAbstractEventTrigger>, Set<? extends Storable>> eventTriggersConverter() {
        return mappingContext -> {
            if (!((Set)mappingContext.getSource()).isEmpty() && !((Set)mappingContext.getDestination()).isEmpty()) {
                if (((Set)mappingContext.getSource()).size() != ((Set)mappingContext.getDestination()).size() || !((Set)mappingContext.getSource()).stream().map(s -> ((HistoryIdentified)s).getId()).collect(Collectors.toList()).containsAll(((Set)mappingContext.getDestination()).stream().map(d -> d.getID()).collect(Collectors.toList()))) {
                    throw new RuntimeException("Cannot restore object because it has different set of triggers.");
                }
                modelMapper.map(((Set)mappingContext.getSource()).iterator().next(), ((Set)mappingContext.getDestination()).iterator().next());
            }
            return (Set)mappingContext.getDestination();
        };
    }

    private static Converter<BigInteger, ? extends Storable> getTemplateByIdConverter() {
        return mappingContext -> Objects.nonNull(mappingContext.getSource()) ? TemplateHelper.getById((Object)mappingContext.getSource()) : null;
    }

    @Transactional
    public LinkedList<Runnable> restoreToRevision(BigInteger objectId, Class<? extends Storable> itemType, Long revisionId, UUID projectUuid) {
        try {
            if (HistoryEntityHelper.isNotSupportEntity(itemType)) {
                String message = String.format("Entity with type %s is skip, because not supported in itf history.", itemType.getName());
                log.warn(message);
                throw new HistoryRestoreException(message);
            }
            Class historyEntityClass = HistoryEntityHelper.getHistoryEntityClass(itemType);
            Optional<Shadow<Object>> optionalShadow = this.getShadow(objectId, historyEntityClass, revisionId);
            if (!optionalShadow.isPresent()) {
                String errorMessage = String.format("Failed to found shadow with id:%s, class:%s", objectId, itemType.getName());
                log.error(errorMessage);
                throw new EntityNotFoundException(errorMessage);
            }
            Object shadowObject = optionalShadow.get().get();
            if (Objects.isNull(shadowObject)) {
                String errorMessage = String.format("Failed to found shadow with id:%s, class:%s", objectId, itemType.getName());
                log.error(errorMessage);
                throw new EntityNotFoundException(errorMessage);
            }
            Object shadowObjectId = ((HistoryIdentified)shadowObject).getId();
            Storable storable = CoreObjectManager.getInstance().getManager(itemType).getById(shadowObjectId);
            this.copyValues(shadowObject, storable);
            this.postActionsToStorable(shadowObject, storable);
            return this.doAfter(storable, projectUuid);
        }
        catch (Exception e) {
            if (e instanceof HistoryRestoreException) {
                throw e;
            }
            throw new HistoryRestoreException(Throwables.getRootCause((Throwable)e).getMessage(), String.valueOf(objectId), itemType.getName());
        }
    }

    private LinkedList<Runnable> doAfter(Storable storable, UUID projectUuid) {
        Optional trigger;
        LinkedList<Runnable> runnableList = new LinkedList<Runnable>();
        runnableList.add(() -> ((Storable)storable).store());
        if (storable instanceof SituationEventTrigger) {
            runnableList.add(() -> this.getMessageToSynchronizeSituationEventTriggers((SituationEventTrigger)storable, projectUuid));
        }
        if (storable instanceof Situation && (trigger = ((Situation)storable).getOperationEventTriggers().stream().findFirst()).isPresent() && ((OperationEventTrigger)trigger.get()).getState().isOn()) {
            runnableList.add(() -> this.getMessageToActivateOperationEventTrigger((OperationEventTrigger)trigger.get(), projectUuid));
        }
        return runnableList;
    }

    private void getMessageToSynchronizeSituationEventTriggers(SituationEventTrigger situationEventTrigger, UUID projectUuid) {
        JSONObject triggerSyncRequest = new JSONObject();
        triggerSyncRequest.put((Object)"user", (Object)"");
        triggerSyncRequest.put((Object)"sessionId", (Object)"");
        triggerSyncRequest.put((Object)"type", (Object)"afterRestoreSituationEventTrigger");
        String action = situationEventTrigger.getState().isOn() ? "triggersToReactivate" : "triggersToDeactivate";
        ArrayList<EventTriggerBriefInfo> triggersList = new ArrayList<EventTriggerBriefInfo>();
        EventTriggerBriefInfo triggerBriefInfo = new EventTriggerBriefInfo(IdConverter.toBigInt((Object)situationEventTrigger.getID()), situationEventTrigger.getType());
        triggersList.add(triggerBriefInfo);
        triggerSyncRequest.put((Object)action, triggersList);
        this.sendMessageForEventTriggersActivation(triggerSyncRequest, projectUuid, (EventTrigger)situationEventTrigger);
    }

    private void getMessageToActivateOperationEventTrigger(OperationEventTrigger operationEventTrigger, UUID projectUuid) {
        JSONObject triggerActivationRequest = new JSONObject();
        triggerActivationRequest.put((Object)"user", (Object)"");
        triggerActivationRequest.put((Object)"sessionId", (Object)"");
        triggerActivationRequest.put((Object)"type", (Object)"afterRestoreOperationEventTrigger");
        EventTriggerBriefInfo triggerBriefInfo = new EventTriggerBriefInfo(IdConverter.toBigInt((Object)operationEventTrigger.getID()), operationEventTrigger.getType());
        triggerActivationRequest.put((Object)"trigger", (Object)triggerBriefInfo);
        this.sendMessageForEventTriggersActivation(triggerActivationRequest, projectUuid, (EventTrigger)operationEventTrigger);
    }

    private void sendMessageForEventTriggersActivation(JSONObject triggerActivationRequest, UUID projectUuid, EventTrigger trigger) {
        try {
            SecurityHelper.addAuthContextToMessage((JSONObject)triggerActivationRequest);
            this.executorToMessageBrokerSender.sendMessage((Object)triggerActivationRequest, "message-broker.configurator-executor-event-triggers.topic", "topic", projectUuid.toString());
        }
        catch (Exception e) {
            throw new HistoryRestoreException("Trigger was restored but reactivation failed with error: \n" + Throwables.getRootCause((Throwable)e).getMessage(), String.valueOf(trigger.getID()), trigger.getClass().getName());
        }
    }

    private void postActionsToStorable(Object shadowObject, Storable storable) {
        Operation operation;
        HistoryCallChain historyCallChain;
        List historySteps;
        if (storable instanceof CallChain && !(historySteps = (historyCallChain = (HistoryCallChain)shadowObject).getSteps()).isEmpty()) {
            CallChain callChain = (CallChain)storable;
            List steps = callChain.getSteps();
            if (historySteps.size() == steps.size()) {
                List historyStepIds = historySteps.stream().map(historyStep -> historyStep.getId()).collect(Collectors.toList());
                List stepIds = steps.stream().map(step -> (BigInteger)step.getID()).collect(Collectors.toList());
                ArrayList<Step> restoreStepsByOrder = new ArrayList<Step>();
                if (historyStepIds.containsAll(stepIds)) {
                    for (HistoryStep historyStep2 : historySteps) {
                        for (Step step2 : steps) {
                            if (!historyStep2.getId().equals(step2.getID())) continue;
                            step2.setOrder(historyStep2.getOrder());
                            restoreStepsByOrder.add(step2);
                        }
                    }
                }
                callChain.fillSteps(restoreStepsByOrder);
            }
        }
        if (storable instanceof Operation && (operation = (Operation)storable).getMep().isInboundRequest()) {
            HistoryOperation historyOperation = (HistoryOperation)shadowObject;
            Set situations = operation.getSituations();
            List historySituations = historyOperation.getSituations().stream().filter(historySituation -> historySituation.getOperationEventTriggers().stream().findFirst().isPresent()).collect(Collectors.toList());
            Map<String, Integer> situationIdAndPriority = historySituations.stream().filter(historySituation -> historySituation.getOperationEventTriggers().stream().findFirst().isPresent()).collect(Collectors.toMap(historySituation -> String.valueOf(historySituation.getId()), historySituation -> historySituation.getOperationEventTriggers().stream().findFirst().map(HistoryOperationEventTrigger::getPriority).get()));
            if (situations.size() == historySituations.size() && historySituations.stream().allMatch(historySituation -> situationIdAndPriority.containsKey(String.valueOf(historySituation.getId())))) {
                situations.forEach(situation -> situation.getOperationEventTriggers().stream().findFirst().ifPresent(trigger -> trigger.setPriority(((Integer)situationIdAndPriority.get(String.valueOf(situation.getID()))).intValue())));
            }
        }
        if (storable instanceof StubProject) {
            this.projectSettingsService.fillCache((StubProject)storable, storable.getStorableProp());
        }
    }

    private void copyValues(Object shadow, @NonNull Storable actualObject) {
        if (actualObject == null) {
            throw new NullPointerException("actualObject");
        }
        modelMapper.map(shadow, (Object)actualObject);
    }

    private Optional<Shadow<Object>> getShadow(BigInteger objectId, Class clazz, Long version) {
        JqlQuery query = QueryBuilder.byInstanceId((Object)objectId, (Class)clazz).withVersion(version.longValue()).withScopeDeepPlus().build();
        List snapshots = this.javers.findSnapshots(query);
        QueryBuilder queryBuilder = QueryBuilder.byInstanceId((Object)objectId, (Class)clazz).withVersion(version.longValue()).withScopeDeepPlus();
        if (Objects.nonNull(snapshots) && !snapshots.isEmpty()) {
            queryBuilder.withCommitId(((CdoSnapshot)snapshots.get(0)).getCommitId());
        }
        List shadows = this.javers.findShadows(queryBuilder.build());
        return shadows.stream().findFirst();
    }

    @ConstructorProperties(value={"javers", "executorToMessageBrokerSender", "projectSettingsService"})
    public HistoryRestoreService(Javers javers, ExecutorToMessageBrokerSender executorToMessageBrokerSender, ProjectSettingsService projectSettingsService) {
        this.javers = javers;
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.projectSettingsService = projectSettingsService;
    }

    static {
        modelMapper.typeMap(HistoryIntegrationConfig.class, IntegrationConfig.class).addMappings(mapper -> mapper.skip(Configuration::setTypeName)).addMapping(HistoryAbstractConfiguration::getConfiguration, Configuration::fillConfiguration);
        modelMapper.typeMap(HistoryOperationTemplate.class, OperationTemplate.class).addMappings(mapper -> mapper.skip(LabeledStorable::setLabels)).addMappings(mapper -> mapper.skip(AbstractTemplate::setTransportProperties)).addMapping(HistoryAbstractTemplate::getLabels, LabeledStorable::fillLabels).addMapping(HistoryAbstractTemplate::getTransportProperties, AbstractTemplate::fillTransportProperties);
        modelMapper.typeMap(HistorySystemTemplate.class, SystemTemplate.class).addMappings(mapper -> mapper.skip(AbstractStorable::setID)).addMappings(mapper -> mapper.skip(LabeledStorable::setLabels)).addMappings(mapper -> mapper.skip(AbstractTemplate::setTransportProperties)).addMapping(HistoryAbstractTemplate::getLabels, LabeledStorable::fillLabels).addMapping(HistoryAbstractTemplate::getTransportProperties, AbstractTemplate::fillTransportProperties);
        modelMapper.emptyTypeMap(HistoryOutboundTemplateTransportConfiguration.class, OutboundTemplateTransportConfiguration.class).addMapping(HistoryAbstractConfiguration::getConfiguration, Configuration::fillConfiguration).addMapping(HistoryAbstractConfiguration::getTypeName, Configuration::setTypeName).addMappings(mapper -> mapper.using(HistoryRestoreService.getTemplateByIdConverter()).map(HistoryOutboundTemplateTransportConfiguration::getParentId, OutboundTemplateTransportConfiguration::setParent));
        modelMapper.typeMap(HistoryCallChain.class, CallChain.class).addMappings(mapper -> mapper.skip(AbstractStorable::setID)).addMappings(mapper -> mapper.skip(CallChain::setProjectId)).addMappings(mapper -> mapper.skip(LabeledStorable::setLabels)).addMapping(HistoryCallChain::getKeys, CallChain::fillKeys).addMapping(HistoryLabeledStorable::getLabels, LabeledStorable::fillLabels).addMappings(mapper -> mapper.map(HistoryAbstractTestCase::getCompatibleDataSetLists, AbstractTestCase::setCompatibleDataSetListIds));
        modelMapper.emptyTypeMap(HistoryStep.class, SituationStep.class).addMappings(mapper -> mapper.skip(AbstractStorable::setID)).addMappings(mapper -> mapper.skip(Storable::setProjectId)).addMappings(mapper -> mapper.skip(AbstractStep::setOrder)).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceConverter(Situation.class)).map(HistoryStep::getSituationId, SituationStep::setSituation)).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceCollectionConverter(Situation.class)).map(HistoryStep::getEndSituationIds, SituationStep::setEndSituations)).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceCollectionConverter(Situation.class)).map(HistoryStep::getExceptionalSituationIds, SituationStep::setExceptionalSituations)).implicitMappings();
        modelMapper.emptyTypeMap(HistoryStep.class, EmbeddedStep.class).addMappings(mapper -> mapper.skip(AbstractStorable::setID)).addMappings(mapper -> mapper.skip(Storable::setProjectId)).addMappings(mapper -> mapper.skip(AbstractStep::setOrder)).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceConverter(CallChain.class)).map(HistoryStep::getChainId, EmbeddedStep::setChain)).implicitMappings();
        modelMapper.emptyTypeMap(HistoryOperation.class, Operation.class).addMappings(mapper -> mapper.skip(AbstractStorable::setID)).addMappings(mapper -> mapper.skip(Operation::setProjectId)).addMappings(mapper -> mapper.skip(Operation::setOperationParsingRules)).addMappings(mapper -> mapper.skip(Operation::setOperationTemplates)).addMappings(mapper -> mapper.skip(Operation::setSituations)).addMappings(mapper -> mapper.skip(Operation::setTransport)).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceConverter(TransportConfiguration.class)).map(HistoryOperation::getTransportConfiguration, Operation::setTransport)).implicitMappings();
        modelMapper.emptyTypeMap(HistorySituation.class, Situation.class).addMappings(mapper -> mapper.skip(Situation::setLabels)).addMappings(mapper -> mapper.skip(Situation::setOperationEventTriggers)).addMappings(mapper -> mapper.skip(Situation::setSituationEventTriggers)).addMappings(mapper -> mapper.skip(Situation::setParsingRules)).addMappings(mapper -> mapper.skip((d, v) -> d.setParent((Operation)v))).addMappings(mapper -> mapper.skip((d, v) -> d.setParent((Storable)v))).addMapping(HistorySituation::getLabels, LabeledStorable::fillLabels).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceListConverter(OperationParsingRule.class)).map(HistorySituation::getParsingRulesIds, Situation::setParsingRules)).addMappings(mapper -> mapper.using(HistoryRestoreService.integrationStepConverter()).map(src -> src, Situation::fillSteps)).implicitMappings();
        modelMapper.emptyTypeMap(HistoryIntegrationStep.class, IntegrationStep.class).addMappings(mapper -> mapper.skip(AbstractStorable::setID)).addMappings(mapper -> mapper.skip(Storable::setProjectId)).addMappings(mapper -> mapper.skip(IntegrationStep::setSystemTemplate)).addMappings(mapper -> mapper.skip(IntegrationStep::setOperationTemplate)).addMappings(mapper -> mapper.skip(IntegrationStep::setReceiver)).addMappings(mapper -> mapper.skip(IntegrationStep::setOperation)).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceToTemplateConverter()).map(HistoryIntegrationStep::getOperationTemplateId, IntegrationStep::setOperationTemplate)).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceToTemplateConverter()).map(HistoryIntegrationStep::getSystemTemplateId, IntegrationStep::setSystemTemplate)).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceConverter(System.class)).map(HistoryIntegrationStep::getReceiverId, IntegrationStep::setReceiver)).implicitMappings();
        modelMapper.emptyTypeMap(HistoryOperationEventTrigger.class, OperationEventTrigger.class).addMappings(mapper -> mapper.skip((d, v) -> d.setParent((Situation)v))).addMappings(mapper -> mapper.skip(EventTriggerImpl::setConditionParameters)).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceConverter(Situation.class)).map(HistoryAbstractEventTrigger::getParentId, (d, v) -> d.setParent((Situation)v))).addMapping(HistoryAbstractEventTrigger::getConditionParameters, EventTriggerImpl::fillConditionParameters).addMapping(HistoryAbstractEventTrigger::getState, EventTriggerImpl::setState);
        modelMapper.emptyTypeMap(HistorySituationEventTrigger.class, SituationEventTrigger.class).addMappings(mapper -> mapper.skip((d, v) -> d.setParent((Situation)v))).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceConverter(Situation.class)).map(HistoryAbstractEventTrigger::getParentId, (d, v) -> d.setParent((Situation)v))).addMapping(HistoryAbstractEventTrigger::getConditionParameters, EventTriggerImpl::fillConditionParameters).addMappings(mapper -> mapper.using(HistoryRestoreService.referenceConverter(Situation.class)).map(HistorySituationEventTrigger::getSituationId, SituationEventTrigger::setSituation)).addMapping(HistoryAbstractEventTrigger::getState, EventTriggerImpl::setState).addMapping(HistorySituationEventTrigger::getOn, (d, v) -> d.setOn((SituationEventTrigger.On)v));
    }
}

