/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.util;

import java.io.InputStream;
import java.util.UUID;
import org.bson.types.ObjectId;
import org.qubership.automation.itf.core.util.eds.model.FileEventType;
import org.qubership.automation.itf.core.util.eds.model.FileInfo;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadHelper {
    private static final Logger log = LoggerFactory.getLogger(FileUploadHelper.class);

    public static void checkStoredObjectIdAndSendMessageToExternalDataStorageUpdateTopic(ObjectId storedObjectId, String fileName, String filePath, String contentType, UUID projectUuid, InputStream inputStream, FileEventType eventType, ExecutorToMessageBrokerSender executorToMessageBrokerSender, String tenantId) {
        log.info("Stored object id for file '{}' is {}null", (Object)fileName, (Object)(storedObjectId == null ? "" : "not "));
        if (storedObjectId != null) {
            FileUploadHelper.sendMessageToExternalDataStorageUpdateTopic(storedObjectId, fileName, filePath, contentType, projectUuid, null, eventType, executorToMessageBrokerSender, tenantId);
        } else {
            FileUploadHelper.sendMessageToExternalDataStorageUpdateTopic(null, fileName, filePath, contentType, projectUuid, inputStream, eventType, executorToMessageBrokerSender, tenantId);
        }
    }

    public static void sendMessageToExternalDataStorageUpdateTopic(ObjectId objectId, String fileName, String filePath, String contentType, UUID projectUuid, InputStream inputStream, FileEventType eventType, ExecutorToMessageBrokerSender executorToMessageBrokerSender, String tenantId) {
        executorToMessageBrokerSender.sendMessageToExternalDataStorageUpdateTopic((Object)new FileInfo(objectId, fileName, filePath, contentType, projectUuid, inputStream, eventType), tenantId);
    }
}

