/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.condition.ConditionsHelper;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.stub.fast.ResponseDescription;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.trigger.IdGenerator;
import org.qubership.automation.itf.trigger.camel.Helper;
import org.qubership.automation.itf.trigger.camel.ToReportingMessageSender;
import org.qubership.automation.itf.trigger.template.velocity.VelocityTemplateEngine;

public class FastStubsHelper {
    private static final ObjectMapper reportingObjectMapper = new ObjectMapper();

    public static ResponseDescription checkConditions(JsonContext context, StubEndpointConfig cfg) {
        if (cfg.getConditionalResponses() != null) {
            for (ResponseDescription responseDescription : cfg.getConditionalResponses()) {
                if (Helper.isTrue(responseDescription.getDisabled()) || StringUtils.isNotEmpty((CharSequence)cfg.getOperationDefinitionKey()) && !cfg.getOperationDefinitionKey().equals(responseDescription.getResponseCondition().getOperationDefinitionKey()) || !ConditionsHelper.isApplicable((JsonContext)context, (List)responseDescription.getResponseCondition().getConditionParameters())) continue;
                return responseDescription;
            }
        }
        return null;
    }

    public static boolean isReportingSkipped(Boolean skipResponseReporting, Boolean skipEndpointReporting) {
        return skipResponseReporting != null ? skipResponseReporting : BooleanUtils.toBooleanDefaultIfNull((Boolean)skipEndpointReporting, (boolean)false);
    }

    public static TextMessage createTextMessage(String text, long time, String id, String type, String tenantId) throws JMSException {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText(text);
        message.setLongProperty("Time", time);
        message.setStringProperty("ObjectID", id);
        message.setStringProperty("ObjectType", type);
        message.setStringProperty("X-Project-Id", tenantId);
        return message;
    }

    public static void sendMessageToReport(Message incoming, Message outgoing, StorableDescriptor triggerDescriptor, Date startTime, Date endTime, JsonContext parsedContext, String endPoint, ResponseDescription responseDescription) throws JsonProcessingException, JMSException {
        TcContext tcContext = new TcContext();
        InstanceContext instanceContext = new InstanceContext();
        String from = "Unknown";
        if (incoming.getHeaders() != null && incoming.getHeaders().get("remoteHost") != null && StringUtils.isNotEmpty((CharSequence)incoming.getHeaders().get("remoteHost").toString())) {
            from = incoming.getHeaders().get("remoteHost").toString();
        }
        SituationInstance situationInstance = new SituationInstance();
        situationInstance.setContext(instanceContext);
        situationInstance.setParentContext(tcContext);
        situationInstance.setName(String.format("From %s to %s", from, endPoint));
        situationInstance.setStartTime(startTime);
        situationInstance.setEndTime(endTime);
        situationInstance.setStatus(Status.PASSED);
        instanceContext.setTC(tcContext);
        String situationName = ((VelocityTemplateEngine)TemplateEngineFactory.get()).process(responseDescription.getName(), parsedContext);
        StepInstance stepInstance = new StepInstance();
        stepInstance.setIncomingMessage(incoming);
        stepInstance.setOutgoingMessage(outgoing);
        stepInstance.setParent((AbstractInstance)situationInstance);
        stepInstance.setName(situationName);
        stepInstance.setStartTime(startTime);
        stepInstance.setEndTime(endTime);
        stepInstance.setStatus(Status.PASSED);
        tcContext.setName(situationName);
        tcContext.setID((Object)IdGenerator.nextId());
        tcContext.setProjectId(triggerDescriptor.getProjectId());
        tcContext.setProjectUuid(triggerDescriptor.getProjectUuid());
        tcContext.setStatus(Status.PASSED);
        tcContext.setStartTime(startTime);
        tcContext.setEndTime(endTime);
        tcContext.putAll((Map)parsedContext);
        String combinedMessage = "{\"TcContext\":" + reportingObjectMapper.writeValueAsString((Object)tcContext) + ", \"SituationInstance\":" + reportingObjectMapper.writeValueAsString((Object)situationInstance) + ", \"StepInstance\":" + reportingObjectMapper.writeValueAsString((Object)stepInstance) + "}";
        TextMessage preparedMessage = FastStubsHelper.createTextMessage(combinedMessage, System.currentTimeMillis(), Config.getConfig().getRunningHostname() + "/" + tcContext.getID(), "combinedFastStubMessage", triggerDescriptor.getProjectUuid().toString());
        ToReportingMessageSender.sendMessageToReportingQueueStatic(preparedMessage);
    }

    private static SimpleFilterProvider configureFilterProvider() {
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("reportWorkerFilter_InstanceContext", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"transport", "version", "history", "collectHistory", "prefix", "description", "empty"}));
        filterProvider.addFilter("reportWorkerFilter_TCContext", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"version", "history", "collectHistory", "prefix", "description", "empty", "lastAccess", "needToReportToATP", "runStepByStep", "running", "finished", "runnable", "parent"}));
        filterProvider.addFilter("reportWorkerFilter_SPContext", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"version", "history", "collectHistory", "prefix", "description", "empty"}));
        filterProvider.addFilter("reportWorkerFilter_MessageParameter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "name", "autosave", "version"}));
        filterProvider.addFilter("reportWorkerFilter_CallChainInstance", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "datasetDefault", "running", "finished", "transportConfiguration", "version"}));
        filterProvider.addFilter("reportWorkerFilter_SituationInstance", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "running", "finished", "transportConfiguration", "version"}));
        filterProvider.addFilter("reportWorkerFilter_StepInstance", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"prefix", "description", "running", "finished", "version", "step"}));
        filterProvider.addFilter("reportWorkerFilter_Message", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"name", "parent", "prefix", "description", "file", "transportProperties", "failedMessage", "version"}));
        return filterProvider;
    }

    public static void recalculateOperationDefinitionKey(StubEndpointConfig cfg, JsonContext context) {
        cfg.setOperationDefinitionKey(null);
        if (StringUtils.isNotEmpty((CharSequence)cfg.getOperationDefinitionScript())) {
            cfg.setOperationDefinitionKey(((VelocityTemplateEngine)TemplateEngineFactory.get()).process(cfg.getOperationDefinitionScript(), context).trim());
        }
    }

    static {
        reportingObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        reportingObjectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        reportingObjectMapper.setFilterProvider((FilterProvider)FastStubsHelper.configureFilterProvider());
    }
}

