/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.camel;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.JvmSettings;
import org.qubership.automation.itf.core.util.config.Config;
import org.springframework.beans.factory.annotation.Value;

public class Helper {
    @Value(value="${lock.provider.check.interval:100}")
    private static int lockProviderCheckInterval;
    @Value(value="${lock.provider.check.maxInterval:800}")
    private static int lockProviderCheckMaxInterval;
    @Value(value="${lock.provider.check.multiplier:1.2}")
    private static float lockProviderCheckMultiplier;

    public static String setExtraProperties(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> item : properties.entrySet()) {
            String key;
            if (StringUtils.isBlank((CharSequence)item.getKey()) || item.getValue() == null || (key = item.getKey().trim()).isEmpty()) continue;
            stringBuilder.append("&").append(key).append("=").append(Helper.processValue(item.getValue()));
        }
        return stringBuilder.toString();
    }

    public static Map<String, Object> setExtraPropertiesMap(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap extraProps = Maps.newHashMapWithExpectedSize((int)properties.size());
        for (Map.Entry<String, Object> item : properties.entrySet()) {
            String key;
            if (StringUtils.isBlank((CharSequence)item.getKey()) || item.getValue() == null || (key = item.getKey().trim()).isEmpty()) continue;
            extraProps.put(key, item.getValue());
        }
        return extraProps;
    }

    public static String getBrokerMessageSelectorValue() {
        return Config.getConfig().getRunningHostname();
    }

    public static int getLockProviderCheckInterval() {
        return lockProviderCheckInterval;
    }

    public static int getLockProviderCheckMaxInterval() {
        return lockProviderCheckMaxInterval;
    }

    public static float getLockProviderCheckMultiplier() {
        return lockProviderCheckMultiplier;
    }

    public static boolean isTrue(Boolean value) {
        return value != null && value != false;
    }

    private static String processValue(Object objValue) {
        try {
            return URLEncoder.encode((String)objValue, JvmSettings.CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return (String)objValue;
        }
    }
}

