/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.camel.route;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.StringSource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileBinding;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.commons.io.IOUtils;
import org.qubership.automation.itf.JvmSettings;
import org.qubership.automation.itf.communication.TriggerExecutionMessageSender;
import org.qubership.automation.itf.core.model.communication.message.CommonTriggerExecutionMessage;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.camel.Helper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ItfAbstractRouteBuilder
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItfAbstractRouteBuilder.class);
    private static final String EXCHANGE_PATTERN_JNDI_PROPERTY = "exchangePattern";
    private static final int MAX_SIZE = Config.getConfig().getIntOrDefault("logging.incoming.request.message.max.size", 0x500000);

    public void startSession(@Nonnull Exchange exchange, @Nonnull String transportClassName, @Nonnull ConnectionProperties transportConfig, @Nonnull StorableDescriptor triggerConfig, @Nonnull String sessionId) throws Exception {
        org.qubership.automation.itf.core.model.jpa.message.Message message = this.prepareIncomingMessage(exchange, transportClassName, transportConfig, triggerConfig, sessionId);
        this.startSession(exchange, transportClassName, transportConfig, triggerConfig, sessionId, message);
    }

    public void startSession(@Nonnull Exchange exchange, @Nonnull String transportClassName, @Nonnull ConnectionProperties transportConfig, @Nonnull StorableDescriptor triggerConfig, @Nonnull String sessionId, @Nonnull org.qubership.automation.itf.core.model.jpa.message.Message message) throws Exception {
        String exchangePattern;
        Map addJndiProps;
        if (exchange.getPattern() == ExchangePattern.InOut && (addJndiProps = (Map)transportConfig.obtain("addJndiProps")) != null && addJndiProps.containsKey(EXCHANGE_PATTERN_JNDI_PROPERTY) && (exchangePattern = (String)addJndiProps.get(EXCHANGE_PATTERN_JNDI_PROPERTY)) != null && exchangePattern.equalsIgnoreCase(ExchangePattern.InOnly.toString())) {
            exchange.setPattern(ExchangePattern.InOnly);
        }
        String brokerMessageSelectorValue = Helper.getBrokerMessageSelectorValue();
        TriggerExecutionMessageSender.send((TriggerExecutionMessage)new CommonTriggerExecutionMessage(transportClassName, message, triggerConfig, sessionId, brokerMessageSelectorValue), (Object)triggerConfig.getProjectUuid());
        LOGGER.debug("Project: {}, SessionId: {}, Broker Message Selector Value: {}, transport: '{}' - message to executor is sent.", new Object[]{triggerConfig.getProjectUuid(), sessionId, brokerMessageSelectorValue, transportClassName});
    }

    public org.qubership.automation.itf.core.model.jpa.message.Message prepareIncomingMessage(@Nonnull Exchange exchange, @Nonnull String transportClassName, @Nonnull ConnectionProperties transportConfig, @Nonnull StorableDescriptor triggerConfig, @Nonnull String sessionId) throws Exception {
        org.qubership.automation.itf.core.model.jpa.message.Message message;
        Message input = exchange.getIn();
        Object messageBody = input.getBody();
        long bodyLength = -1L;
        if (messageBody instanceof CxfPayload) {
            message = new org.qubership.automation.itf.core.model.jpa.message.Message(((StringSource)((CxfPayload)messageBody).getBodySources().get(0)).getText());
        } else if (messageBody instanceof InputStream) {
            String charset = JvmSettings.CHARSET_NAME;
            if (input.getHeaders() != null && input.getHeaders().containsKey("CamelHttpCharacterEncoding")) {
                Object encodingHeader = input.getHeader("CamelHttpCharacterEncoding");
                charset = encodingHeader.equals("Shift_JIS") ? "MS932" : encodingHeader.toString();
            }
            message = new org.qubership.automation.itf.core.model.jpa.message.Message(IOUtils.toString((InputStream)((InputStream)messageBody), (String)charset));
        } else if (messageBody instanceof RemoteFile) {
            RemoteFile remoteFile = (RemoteFile)messageBody;
            GenericFileBinding gfb = remoteFile.getBinding();
            GenericFile gf = new GenericFile();
            ByteArrayOutputStream ba = (ByteArrayOutputStream)gfb.getBody(gf);
            message = new org.qubership.automation.itf.core.model.jpa.message.Message(ba.toString(JvmSettings.CHARSET_NAME));
        } else if (messageBody instanceof GenericFile) {
            message = new org.qubership.automation.itf.core.model.jpa.message.Message((File)((GenericFile)messageBody).getFile());
            bodyLength = ((GenericFile)messageBody).getFileLength();
        } else {
            message = messageBody instanceof byte[] ? new org.qubership.automation.itf.core.model.jpa.message.Message(new String((byte[])messageBody, StandardCharsets.UTF_8)) : new org.qubership.automation.itf.core.model.jpa.message.Message((String)messageBody);
        }
        message.convertAndSetHeaders(input.getHeaders(), this.getExcludeHeadersList());
        if (bodyLength == -1L) {
            bodyLength = message.getText() == null ? 0L : (long)message.getText().length();
        }
        MetricsAggregateService.checkIncomingMessageSize((UUID)triggerConfig.getProjectUuid(), (long)bodyLength);
        ItfAbstractRouteBuilder.logExtendedInfo(triggerConfig.getProjectUuid(), sessionId, Helper.getBrokerMessageSelectorValue(), transportClassName, bodyLength);
        message.getConnectionProperties().putAll(transportConfig);
        message.getConnectionProperties().putAll(this.getAdditionalProperties(exchange));
        return message;
    }

    public static void logExtendedInfo(UUID projectUuid, String sessionId, String brokerMessageSelectorValue, String transportClassName, long length) {
        LOGGER.debug("Project: {}, SessionId: {}, " + (length >= (long)MAX_SIZE ? String.format("Message size: %s (bytes), ", length) : "") + "Broker Message Selector Value: {}, transport: '{}' - sending message to executor...", new Object[]{projectUuid, sessionId, brokerMessageSelectorValue, transportClassName});
    }

    public abstract Map<String, Object> getAdditionalProperties(Exchange var1);

    public abstract List<String> getExcludeHeadersList();
}

