/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.template.velocity;

import com.google.common.base.Strings;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.Data;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.config.ToolConfiguration;
import org.apache.velocity.tools.config.ToolboxConfiguration;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.engine.TemplateEngine;
import org.qubership.automation.itf.core.util.helper.ClassResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityTemplateEngine
implements TemplateEngine {
    private static final Logger log = LoggerFactory.getLogger(VelocityTemplateEngine.class);
    private VelocityEngine engine;
    private ToolManager toolManager;

    public VelocityTemplateEngine() {
        String velocityConfig = Config.getConfig().getString("velocity.config");
        if (!Strings.isNullOrEmpty((String)velocityConfig)) {
            log.info("Init Apache Velocity engine with settings {}", (Object)velocityConfig);
            this.engine = new VelocityEngine(velocityConfig);
        } else {
            log.info("Init Apache Velocity engine with default settings");
            this.engine = new VelocityEngine();
        }
        this.engine.setProperty("velocimacro.permissions.allow.inline.to.replace.global", (Object)"true");
        this.engine.setProperty("console.logsystem.max.level", (Object)"WARN");
        this.engine.setProperty("runtime.log.logsystem.max.level", (Object)"WARN");
        this.engine.init();
        for (Class directiveClass : ClassResolver.getInstance().getSubtypesOf(Directive.class)) {
            this.engine.loadDirective(directiveClass.getName());
        }
        FactoryConfiguration factoryConfiguration = VelocityTemplateEngine.makeGenericFactoryConfig();
        factoryConfiguration.addConfiguration(VelocityTemplateEngine.makeStrutsFactoryConfig());
        factoryConfiguration.addConfiguration(VelocityTemplateEngine.makeViewFactoryConfig());
        this.toolManager = new ToolManager();
        this.toolManager.getToolboxFactory().configure(factoryConfiguration);
        this.toolManager.setVelocityEngine(this.engine);
    }

    private static Data fillData(String type, String key, Object value) {
        Data data = new Data();
        data.setType(type);
        data.setKey(key);
        data.setValue(value);
        return data;
    }

    private static List<ToolConfiguration> makeToolsList(String ... args) {
        ArrayList<ToolConfiguration> list = new ArrayList<ToolConfiguration>();
        for (String arg : args) {
            ToolConfiguration cfg = new ToolConfiguration();
            cfg.setClassname(arg);
            list.add(cfg);
        }
        return list;
    }

    private static FactoryConfiguration makeGenericFactoryConfig() {
        FactoryConfiguration factoryConfiguration = new FactoryConfiguration();
        factoryConfiguration.addData(VelocityTemplateEngine.fillData("number", "TOOLS_VERSION", "2.0"));
        factoryConfiguration.addData(VelocityTemplateEngine.fillData("boolean", "GENERIC_TOOLS_AVAILABLE", "true"));
        ToolboxConfiguration applicationToolboxConfiguration = new ToolboxConfiguration();
        applicationToolboxConfiguration.setScope("application");
        applicationToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.generic.AlternatorTool", "org.apache.velocity.tools.generic.ClassTool", "org.apache.velocity.tools.generic.ComparisonDateTool", "org.apache.velocity.tools.generic.ConversionTool", "org.apache.velocity.tools.generic.DisplayTool", "org.apache.velocity.tools.generic.EscapeTool", "org.apache.velocity.tools.generic.FieldTool", "org.apache.velocity.tools.generic.MathTool", "org.apache.velocity.tools.generic.NumberTool", "org.apache.velocity.tools.generic.ResourceTool", "org.apache.velocity.tools.generic.SortTool", "org.apache.velocity.tools.generic.XmlTool"));
        factoryConfiguration.addToolbox(applicationToolboxConfiguration);
        ToolboxConfiguration requestToolboxConfiguration = new ToolboxConfiguration();
        requestToolboxConfiguration.setScope("request");
        requestToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.generic.ContextTool", "org.apache.velocity.tools.generic.LinkTool", "org.apache.velocity.tools.generic.LoopTool", "org.apache.velocity.tools.generic.RenderTool"));
        factoryConfiguration.addToolbox(requestToolboxConfiguration);
        return factoryConfiguration;
    }

    private static FactoryConfiguration makeStrutsFactoryConfig() {
        FactoryConfiguration factoryConfiguration = new FactoryConfiguration();
        factoryConfiguration.addData(VelocityTemplateEngine.fillData("boolean", "STRUTS_TOOLS_AVAILABLE", "true"));
        ToolboxConfiguration requestToolboxConfiguration = new ToolboxConfiguration();
        requestToolboxConfiguration.setScope("request");
        requestToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.struts.ActionMessagesTool", "org.apache.velocity.tools.struts.ErrorsTool", "org.apache.velocity.tools.struts.FormTool", "org.apache.velocity.tools.struts.MessageTool", "org.apache.velocity.tools.struts.StrutsLinkTool", "org.apache.velocity.tools.struts.TilesTool", "org.apache.velocity.tools.struts.ValidatorTool"));
        factoryConfiguration.addToolbox(requestToolboxConfiguration);
        return factoryConfiguration;
    }

    private static FactoryConfiguration makeViewFactoryConfig() {
        FactoryConfiguration factoryConfiguration = new FactoryConfiguration();
        factoryConfiguration.addData(VelocityTemplateEngine.fillData("boolean", "VIEW_TOOLS_AVAILABLE", "true"));
        ToolboxConfiguration requestToolboxConfiguration = new ToolboxConfiguration();
        requestToolboxConfiguration.setScope("request");
        requestToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.view.CookieTool", "org.apache.velocity.tools.view.ImportTool", "org.apache.velocity.tools.view.IncludeTool", "org.apache.velocity.tools.view.LinkTool", "org.apache.velocity.tools.view.PagerTool", "org.apache.velocity.tools.view.ParameterTool", "org.apache.velocity.tools.view.ViewContextTool", "org.apache.velocity.tools.generic.ResourceTool"));
        factoryConfiguration.addToolbox(requestToolboxConfiguration);
        ToolboxConfiguration sessionToolboxConfiguration = new ToolboxConfiguration();
        sessionToolboxConfiguration.setScope("session");
        sessionToolboxConfiguration.setProperty("createSession", (Object)"false");
        sessionToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.view.BrowserTool"));
        factoryConfiguration.addToolbox(sessionToolboxConfiguration);
        return factoryConfiguration;
    }

    public String process(String someString, JsonContext context) {
        if (StringUtils.isBlank((CharSequence)someString)) {
            return "";
        }
        ToolContext velocityContext = this.toolManager.createContext();
        return this.processing(someString, context, (Context)velocityContext);
    }

    public String process(Storable owner, String someString, JsonContext context) {
        return this.process(someString, context);
    }

    public String process(Map<String, Storable> storables, String someString, JsonContext context) {
        return this.process(someString, context);
    }

    public String process(Storable owner, String someString, JsonContext context, String coords) {
        return this.process(someString, context);
    }

    public String process(Map<String, Storable> storables, String someString, JsonContext context, String coords) {
        return this.process(someString, context);
    }

    private String processing(String someString, JsonContext context, Context velocityContext) {
        if (StringUtils.isBlank((CharSequence)someString)) {
            return "";
        }
        log.debug("Processing string with Velocity...");
        log.trace("String to process: {}", (Object)someString);
        for (Object o : context.entrySet()) {
            Map.Entry entry = (Map.Entry)o;
            velocityContext.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        StringWriter stringWriter = new StringWriter(someString.length());
        try {
            this.engine.evaluate(velocityContext, (Writer)stringWriter, "VeLog", someString);
        }
        catch (Exception e) {
            throw new VelocityException(String.format("Error occurred while processing template '%s'. %s", "VeLog", e.getMessage()), (Throwable)e);
        }
        String string = stringWriter.toString();
        log.debug("String processed");
        log.trace("Result string is: {}", (Object)string);
        return string;
    }
}

