/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.qubership.atp.multitenancy.interceptor.jms.AtpJmsTemplate;
import org.qubership.automation.itf.core.util.engine.TemplateEngine;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.trigger.template.velocity.VelocityTemplateEngine;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;

@Configuration
public class FastStubsConfiguration {
    @Value(value="${message-broker.url}")
    private String brokerUrl;
    @Value(value="${message-broker.reports.useCompression}")
    private String reportsUseCompression;
    @Value(value="${message-broker.reports.useAsyncSend}")
    private String reportsUseAsyncSend;
    @Value(value="${message-broker.reports.maxThreadPoolSize}")
    private int maxThreadPoolSize;
    @Value(value="${message-broker.reports.connectionsPoolSize}")
    private int connectionsPoolSize;
    @Value(value="${message-broker.reports.message-time-to-live:180000}")
    private int reportingQueueMessagesTimeToLive;

    @Bean
    public VelocityTemplateEngine fastStubVelocityTemplateEngine() {
        return new VelocityTemplateEngine();
    }

    @Bean
    public ActiveMQConnectionFactory reportsActiveMqConnectionFactory() {
        ActiveMQConnectionFactory activeMqConnectionFactory = new ActiveMQConnectionFactory();
        activeMqConnectionFactory.setBrokerURL(this.brokerUrl);
        activeMqConnectionFactory.setMaxThreadPoolSize(this.maxThreadPoolSize);
        activeMqConnectionFactory.setUseCompression(Boolean.parseBoolean(this.reportsUseCompression));
        activeMqConnectionFactory.setUseAsyncSend(Boolean.parseBoolean(this.reportsUseAsyncSend));
        activeMqConnectionFactory.setAlwaysSyncSend(!activeMqConnectionFactory.isUseAsyncSend());
        return activeMqConnectionFactory;
    }

    @Bean
    public ConnectionFactory reportsPooledConnectionFactory(ActiveMQConnectionFactory reportsActiveMqConnectionFactory) {
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory();
        pooledConnectionFactory.setConnectionFactory((Object)reportsActiveMqConnectionFactory);
        pooledConnectionFactory.setMaxConnections(this.connectionsPoolSize);
        pooledConnectionFactory.setCreateConnectionOnStartup(true);
        return pooledConnectionFactory;
    }

    @Bean(name={"TemplateEngineFactory"})
    public TemplateEngine getTemplateEngineFactory() {
        TemplateEngineFactory.init((TemplateEngine)this.fastStubVelocityTemplateEngine());
        return TemplateEngineFactory.get();
    }

    @Bean
    public AtpJmsTemplate reportsQueueJmsTemplate(AtpJmsTemplate reportingJmsTemplateInstance) {
        reportingJmsTemplateInstance.setPubSubDomain(false);
        if (reportingJmsTemplateInstance instanceof JmsTemplate) {
            ((JmsTemplate)reportingJmsTemplateInstance).setExplicitQosEnabled(true);
            ((JmsTemplate)reportingJmsTemplateInstance).setTimeToLive((long)this.reportingQueueMessagesTimeToLive);
        }
        return reportingJmsTemplateInstance;
    }
}

