/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.camel;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.exception.Exceptions;
import org.qubership.automation.itf.core.util.exception.TriggerException;
import org.qubership.automation.itf.trigger.camel.Trigger;

public abstract class AbstractTriggerImpl
implements Trigger {
    private TriggerState state = TriggerState.INACTIVE;
    private final StorableDescriptor triggerConfigurationDescriptor;
    private ConnectionProperties connectionProperties;
    private String error;

    protected AbstractTriggerImpl(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        this.triggerConfigurationDescriptor = triggerConfigurationDescriptor;
        this.connectionProperties = connectionProperties;
    }

    @Override
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Checked; it's correct")
    public final TriggerState getState() {
        return this.state;
    }

    @Override
    public final synchronized void activate() throws TriggerException {
        this.error = null;
        this.state = TriggerState.STARTING;
        try {
            this.activateSpecificTrigger();
            this.state = TriggerState.ACTIVE;
        }
        catch (Throwable e) {
            this.state = TriggerState.ERROR;
            this.error = Exceptions.getMessagesOnly((Throwable)e);
            try {
                this.deactivateSpecificTrigger();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TriggerException(String.format("Unable to activate trigger for configuration %s", this.triggerConfigurationDescriptor.getName()), e);
        }
    }

    protected abstract void activateSpecificTrigger() throws Exception;

    @Override
    public final synchronized void deactivate() throws TriggerException {
        this.error = null;
        this.state = TriggerState.SHUTTING_DOWN;
        try {
            this.deactivateSpecificTrigger();
            this.state = TriggerState.INACTIVE;
        }
        catch (Exception e) {
            this.state = TriggerState.ERROR;
            this.error = ExceptionUtils.getStackTrace((Throwable)e);
            throw new TriggerException(String.format("Unable to deactivate trigger for configuration %s", this.triggerConfigurationDescriptor.getName()), (Throwable)e);
        }
    }

    protected abstract void deactivateSpecificTrigger() throws Exception;

    @Override
    public StorableDescriptor getTriggerConfigurationDescriptor() {
        return this.triggerConfigurationDescriptor;
    }

    protected ConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    protected void setConnectionProperties(ConnectionProperties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    @Override
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Checked; it's correct")
    public String getError() {
        return this.error;
    }

    @Override
    public void applyConfiguration(ConnectionProperties connectionProperties) throws TriggerException {
        if (this.state.isOn()) {
            this.deactivate();
        }
        this.applyTriggerProperties(connectionProperties);
        if (this.state.isOn()) {
            this.activate();
        }
    }

    protected abstract void applyTriggerProperties(ConnectionProperties var1) throws TriggerException;

    protected String getPrefixWithProjectUuid() {
        return "/" + this.getTriggerConfigurationDescriptor().getProjectUuid();
    }

    @Override
    public boolean checkIfServerAvailable(Map<String, Boolean> availableServers) {
        return true;
    }
}

