/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.camel;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.qubership.atp.multitenancy.interceptor.jms.AtpJmsTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ToReportingMessageSender {
    private static AtpJmsTemplate reportsQueueJmsTemplateStatic;
    private static String reportsIntegrationQueueStatic;
    private AtpJmsTemplate reportsQueueJmsTemplate;
    private String reportsIntegrationQueue;

    @Autowired
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="No way due to usage inside Camel .process() method")
    public ToReportingMessageSender(AtpJmsTemplate reportsQueueJmsTemplate, @Value(value="${message-broker.reports.queue}") String reportsIntegrationQueue) {
        this.reportsQueueJmsTemplate = reportsQueueJmsTemplate;
        this.reportsIntegrationQueue = reportsIntegrationQueue;
        reportsQueueJmsTemplateStatic = reportsQueueJmsTemplate;
        reportsIntegrationQueueStatic = reportsIntegrationQueue;
    }

    public void sendMessageToReportingQueue(Object message) {
        this.reportsQueueJmsTemplate.convertAndSend(this.reportsIntegrationQueue, message);
    }

    public static void sendMessageToReportingQueueStatic(Object message) {
        reportsQueueJmsTemplateStatic.convertAndSend(reportsIntegrationQueueStatic, message);
    }
}

