/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.communication;

import java.util.Map;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.EventDrivenConsumerRoute;

public class RoutesInformationResponse {
    private ServiceStatus serviceStatus;
    private String version;
    private String consumer;
    private String consumerClassName;
    private String endpoint;
    private Map<String, Object> routeProperties;
    private Object routeId;

    public RoutesInformationResponse(EventDrivenConsumerRoute route) {
        this.serviceStatus = route.getStatus();
        this.consumer = route.getConsumer().toString();
        this.consumerClassName = route.getConsumer().getClass().getSimpleName();
        this.endpoint = route.getEndpoint().toString();
        this.version = route.getVersion();
        this.routeProperties = route.getProperties();
        this.routeId = this.routeProperties.get("id");
    }

    public ServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    public String getVersion() {
        return this.version;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public String getConsumerClassName() {
        return this.consumerClassName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, Object> getRouteProperties() {
        return this.routeProperties;
    }

    public Object getRouteId() {
        return this.routeId;
    }

    public void setServiceStatus(ServiceStatus serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setConsumer(String consumer) {
        this.consumer = consumer;
    }

    public void setConsumerClassName(String consumerClassName) {
        this.consumerClassName = consumerClassName;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setRouteProperties(Map<String, Object> routeProperties) {
        this.routeProperties = routeProperties;
    }

    public void setRouteId(Object routeId) {
        this.routeId = routeId;
    }
}

