/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.config.jms;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.qubership.atp.multitenancy.interceptor.jms.AtpJmsTemplate;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;

public class DefaultJmsTemplate
extends JmsTemplate
implements AtpJmsTemplate {
    public void convertAndSend(String destination, Object message, Map<String, Object> properties) throws JmsException {
        super.send(destination, session -> {
            MessageConverter messageConverter = super.getMessageConverter();
            if (messageConverter == null) {
                throw new RuntimeException(String.format("MessageConverter wasn't configured for %s destination", destination));
            }
            Message messageToSend = messageConverter.toMessage(message, session);
            this.setStringProperties(properties, messageToSend);
            return messageToSend;
        });
    }

    private void setStringProperties(Map<String, Object> properties, Message messageToSend) throws JMSException {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            messageToSend.setStringProperty(property.getKey(), String.valueOf(property.getValue()));
        }
    }
}

