/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.config.jms.connection;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessageType;

@ComponentScan(basePackages={"org.qubership.automation.itf.communication"})
@Configuration
@EnableJms
public class StubsIntegrationConfig {
    @Value(value="${message-broker.url}")
    private String brokerUrl;
    @Value(value="${message-broker.queuePrefetch}")
    private int queuePrefetch;

    @Bean
    public ActiveMQConnectionFactory activeMqConnectionFactory() {
        ActiveMQConnectionFactory activeMqConnectionFactory = new ActiveMQConnectionFactory();
        activeMqConnectionFactory.setBrokerURL(this.brokerUrl);
        activeMqConnectionFactory.setUseAsyncSend(true);
        activeMqConnectionFactory.setUseRetroactiveConsumer(true);
        activeMqConnectionFactory.setTrustAllPackages(true);
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(this.queuePrefetch);
        activeMqConnectionFactory.setPrefetchPolicy(prefetchPolicy);
        return activeMqConnectionFactory;
    }

    @Bean
    public MessageConverter jacksonJmsMessageConverter(@Qualifier(value="jmsMessageConverterObjectMapper") ObjectMapper jmsMessageConverterObjectMapper) {
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setTargetType(MessageType.TEXT);
        converter.setTypeIdPropertyName("_type");
        converter.setObjectMapper(jmsMessageConverterObjectMapper);
        return converter;
    }

    @Bean
    public ObjectMapper jmsMessageConverterObjectMapper() {
        ObjectMapper jmsMessageConverterObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, false).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.setFailOnUnknownId(false);
        jmsMessageConverterObjectMapper.setFilterProvider((FilterProvider)filterProvider);
        return jmsMessageConverterObjectMapper;
    }

    @Bean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }
}

