/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.config.jms.listener.factory;

import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;

@ComponentScan(basePackages={"org.qubership.automation.itf.communication"})
@Configuration
@EnableJms
public class QueueJmsListenerContainerFactoryConfiguration {
    @Value(value="${message-broker.executor-stubs.listenerContainerFactory.concurrency}")
    private String executorStubsListenerConcurrency;
    @Value(value="${message-broker.executor-stubs.listenerContainerFactory.maxMessagesPerTask}")
    private String executorStubsListenerMaxMessagesPerTask;

    @Bean
    public DefaultJmsListenerContainerFactory stubsQueueJmsListenerContainerFactory(ConnectionFactory activeMqConnectionFactory, DefaultJmsListenerContainerFactory jmsQueueListenerContainerFactoryInstance) {
        int maxMessagesPerTask;
        jmsQueueListenerContainerFactoryInstance.setConnectionFactory(activeMqConnectionFactory);
        jmsQueueListenerContainerFactoryInstance.setPubSubDomain(Boolean.valueOf(false));
        jmsQueueListenerContainerFactoryInstance.setConcurrency(this.executorStubsListenerConcurrency);
        jmsQueueListenerContainerFactoryInstance.setAutoStartup(false);
        if (!(this.executorStubsListenerMaxMessagesPerTask == null || this.executorStubsListenerMaxMessagesPerTask.isEmpty() || (maxMessagesPerTask = Integer.parseInt(this.executorStubsListenerMaxMessagesPerTask)) != -1 && maxMessagesPerTask <= 0)) {
            jmsQueueListenerContainerFactoryInstance.setMaxMessagesPerTask(Integer.valueOf(maxMessagesPerTask));
        }
        jmsQueueListenerContainerFactoryInstance.setCacheLevel(Integer.valueOf(3));
        jmsQueueListenerContainerFactoryInstance.setSessionAcknowledgeMode(Integer.valueOf(4));
        return jmsQueueListenerContainerFactoryInstance;
    }
}

