/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.communication;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import feign.RetryableException;
import feign.Retryer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FeignRetryer
implements Retryer {
    private static final Logger log = LoggerFactory.getLogger(FeignRetryer.class);
    private int retryMaxAttempt;
    private long retryInterval;
    private int attempt = 1;

    public FeignRetryer(int retryMaxAttempt, long retryInterval) {
        this.retryMaxAttempt = retryMaxAttempt;
        this.retryInterval = retryInterval;
    }

    public void continueOrPropagate(RetryableException e) {
        log.info("Feign retry attempt {} due to {} ", (Object)this.attempt, (Object)e.getMessage());
        if (this.attempt++ == this.retryMaxAttempt) {
            throw e;
        }
        try {
            Thread.sleep(this.retryInterval);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="Checked; super call is not needed")
    public Retryer clone() {
        return new FeignRetryer(5, 2000L);
    }

    public FeignRetryer() {
    }
}

