/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.communication;

import java.util.HashMap;
import org.qubership.atp.multitenancy.interceptor.jms.AtpJmsTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class StubsIntegrationMessageSender {
    private final AtpJmsTemplate integrationJmsTemplate;
    @Value(value="${message-broker.stubs-configurator.topic}")
    private String topic;
    @Value(value="${message-broker.eds-update.topic}")
    private String externalDataStorageUpdateTopic;

    public void send(Object message, Object tenantId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("X-Project-Id", tenantId);
        this.integrationJmsTemplate.convertAndSend(this.topic, message, properties);
    }

    public void sendToEdsUpdateTopic(Object message, Object tenantId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("X-Project-Id", tenantId);
        this.integrationJmsTemplate.convertAndSend(this.externalDataStorageUpdateTopic, message, properties);
    }

    public StubsIntegrationMessageSender(AtpJmsTemplate integrationJmsTemplate) {
        this.integrationJmsTemplate = integrationJmsTemplate;
    }
}

