/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.communication;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import org.qubership.atp.multitenancy.interceptor.jms.AtpJmsTemplate;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TriggerExecutionMessageSender {
    private static AtpJmsTemplate executorJmsTemplate;
    private static String queue;

    @Autowired
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="No way due to usage inside Camel .process() method")
    public TriggerExecutionMessageSender(@Value(value="${message-broker.stubs-executor-incoming-request.queue}") String queue, AtpJmsTemplate executorJmsTemplate) {
        TriggerExecutionMessageSender.executorJmsTemplate = executorJmsTemplate;
        TriggerExecutionMessageSender.queue = queue;
    }

    public static void send(TriggerExecutionMessage message, Object tenantId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("X-Project-Id", tenantId);
        properties.put("traceId", MDC.get((String)"traceId"));
        executorJmsTemplate.convertAndSend(queue, (Object)message, properties);
    }
}

