/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.config.jms.template.instance;

import javax.jms.ConnectionFactory;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.integration.config.jms.DefaultJmsTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"atp.multi-tenancy.enabled"}, havingValue="false", matchIfMissing=true)
public class DefaultJmsTemplateInstancesConfiguration {
    private final ConnectionFactory activeMqConnectionFactory;
    private final ConnectionFactory reportsPooledConnectionFactory;

    @Bean
    public DefaultJmsTemplate integrationJmsTemplateInstance() {
        return this.initDefaultJmsTemplate(this.activeMqConnectionFactory);
    }

    @Bean
    public DefaultJmsTemplate executorJmsTemplateInstance() {
        return this.initDefaultJmsTemplate(this.activeMqConnectionFactory);
    }

    @Bean
    public DefaultJmsTemplate reportingJmsTemplateInstance() {
        return this.initDefaultJmsTemplate(this.reportsPooledConnectionFactory);
    }

    @NotNull
    private DefaultJmsTemplate initDefaultJmsTemplate(ConnectionFactory connectionFactory) {
        DefaultJmsTemplate defaultJmsTemplate = new DefaultJmsTemplate();
        defaultJmsTemplate.setConnectionFactory(connectionFactory);
        return defaultJmsTemplate;
    }

    public DefaultJmsTemplateInstancesConfiguration(ConnectionFactory activeMqConnectionFactory, ConnectionFactory reportsPooledConnectionFactory) {
        this.activeMqConnectionFactory = activeMqConnectionFactory;
        this.reportsPooledConnectionFactory = reportsPooledConnectionFactory;
    }
}

