/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.config.jms.template.instance;

import javax.jms.ConnectionFactory;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.multitenancy.interceptor.jms.MultiTenantJmsTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"atp.multi-tenancy.enabled"}, havingValue="true")
public class MultiTenantJmsTemplateInstancesConfiguration {
    private final ConnectionFactory activeMqConnectionFactory;
    private final ConnectionFactory reportsPooledConnectionFactory;

    @Bean
    public MultiTenantJmsTemplate integrationJmsTemplateInstance() {
        return this.initMultiTenantJmsTemplate(this.activeMqConnectionFactory);
    }

    @Bean
    public MultiTenantJmsTemplate executorJmsTemplateInstance() {
        return this.initMultiTenantJmsTemplate(this.activeMqConnectionFactory);
    }

    @Bean
    public MultiTenantJmsTemplate reportingJmsTemplateInstance() {
        return this.initMultiTenantJmsTemplate(this.reportsPooledConnectionFactory);
    }

    @NotNull
    private MultiTenantJmsTemplate initMultiTenantJmsTemplate(ConnectionFactory connectionFactory) {
        MultiTenantJmsTemplate multiTenantJmsTemplate = new MultiTenantJmsTemplate();
        multiTenantJmsTemplate.setConnectionFactory(connectionFactory);
        return multiTenantJmsTemplate;
    }

    public MultiTenantJmsTemplateInstancesConfiguration(ConnectionFactory activeMqConnectionFactory, ConnectionFactory reportsPooledConnectionFactory) {
        this.activeMqConnectionFactory = activeMqConnectionFactory;
        this.reportsPooledConnectionFactory = reportsPooledConnectionFactory;
    }
}

