/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.monitoring.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.JvmSettings;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.monitoring.metrics.Metric;
import org.qubership.automation.itf.monitoring.metrics.MetricTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetricsAggregateService {
    private static final Logger log = LoggerFactory.getLogger(MetricsAggregateService.class);
    private static final int MAX_SIZE = Config.getConfig().getIntOrDefault("logging.incoming.request.message.max.size", 0x500000);
    private static int MAX_SIZE_TO_MB = MAX_SIZE / 0x100000;
    private Counter.Builder stubsActiveTriggerCounter;
    private Counter.Builder stubsErrorTriggerCounter;
    private static Counter.Builder stubsIncomingMessageSizeCounter;
    private static Counter.Builder stubsIncomingRequestCounter;
    private static MeterRegistry meterRegistry;

    @Autowired
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="No way due to usage inside Camel .process() method")
    public MetricsAggregateService(MeterRegistry meterRegistry) {
        MetricsAggregateService.meterRegistry = meterRegistry;
        this.stubsActiveTriggerCounter = Counter.builder((String)Metric.ATP_ITF_STUBS_ACTIVE_TRIGGER_BY_PROJECT.getValue()).description("total number of active trigger");
        this.stubsErrorTriggerCounter = Counter.builder((String)Metric.ATP_ITF_STUBS_ERROR_TRIGGER_BY_PROJECT.getValue()).description("total number of error trigger");
        stubsIncomingMessageSizeCounter = Counter.builder((String)Metric.ATP_ITF_STUBS_INCOMING_REQUEST_MESSAGE_SIZE_BY_PROJECT.getValue()).description("total number of incoming message size");
        stubsIncomingRequestCounter = Counter.builder((String)Metric.ATP_ITF_STUBS_INCOMING_REQUEST_BY_PROJECT.getValue()).description("total number of incoming request");
    }

    public void incrementRequestToProject(@NonNull UUID projectUuid, @NonNull Metric metric) {
        if (projectUuid == null) {
            throw new NullPointerException("projectUuid is marked non-null but is null");
        }
        if (metric == null) {
            throw new NullPointerException("metric is marked non-null but is null");
        }
        this.requestToProject(projectUuid, metric);
    }

    public static void incrementIncomingRequestToProject(@NonNull UUID projectUuid, @NonNull TransportType transportType, boolean result) {
        if (projectUuid == null) {
            throw new NullPointerException("projectUuid is marked non-null but is null");
        }
        if (transportType == null) {
            throw new NullPointerException("transportType is marked non-null but is null");
        }
        stubsIncomingRequestCounter.tag(MetricTag.PROJECT.getValue(), projectUuid.toString()).tag(MetricTag.TRANSPORT_TYPE.getValue(), transportType.name()).tag(MetricTag.RESULT.getValue(), String.valueOf(result)).register(meterRegistry).increment();
    }

    public static void checkIncomingMessageSize(UUID projectUuid, String message) {
        if (Objects.isNull(message)) {
            return;
        }
        MetricsAggregateService.checkIncomingMessageSize(projectUuid, message.getBytes(JvmSettings.CHARSET).length);
    }

    public static void checkIncomingMessageSize(UUID projectUuid, long length) {
        if (length >= (long)MAX_SIZE) {
            log.warn("Received message is more or equal to {} Mb, project UUID:{}, message size: {} bytes.", new Object[]{MAX_SIZE_TO_MB, projectUuid, length});
            stubsIncomingMessageSizeCounter.tag(MetricTag.PROJECT.getValue(), projectUuid.toString()).register(meterRegistry).increment();
        }
    }

    public static void recordIncomingRequestDuration(@NonNull UUID projectUuid, @NonNull TransportType transportType, @NonNull String endPoint, @NonNull Duration duration) {
        if (projectUuid == null) {
            throw new NullPointerException("projectUuid is marked non-null but is null");
        }
        if (transportType == null) {
            throw new NullPointerException("transportType is marked non-null but is null");
        }
        if (endPoint == null) {
            throw new NullPointerException("endPoint is marked non-null but is null");
        }
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        meterRegistry.timer(Metric.ATP_ITF_STUBS_INCOMING_REQUEST_SECONDS_BY_PROJECT.getValue(), new String[]{MetricTag.PROJECT.getValue(), projectUuid.toString(), MetricTag.TRANSPORT_TYPE.getValue(), transportType.name(), MetricTag.ENDPOINT.getValue(), endPoint}).record(duration);
    }

    public static void putCommonMetrics(UUID projectId, String sessionId) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectId);
        MdcUtils.put((String)MdcField.SESSION_ID.toString(), (String)sessionId);
    }

    private void requestToProject(UUID projectUuid, Metric metric) {
        switch (metric) {
            case ATP_ITF_STUBS_ACTIVE_TRIGGER_BY_PROJECT: {
                this.stubsActiveTriggerCounter.tag(MetricTag.PROJECT.getValue(), projectUuid.toString()).register(meterRegistry).increment();
                break;
            }
            case ATP_ITF_STUBS_ERROR_TRIGGER_BY_PROJECT: {
                this.stubsErrorTriggerCounter.tag(MetricTag.PROJECT.getValue(), projectUuid.toString()).register(meterRegistry).increment();
                break;
            }
        }
    }
}

