/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.configuration.dataset.impl.excel;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.ss.usermodel.Cell;
import org.qubership.automation.configuration.dataset.excel.builder.DataSetBuilder;
import org.qubership.automation.configuration.dataset.excel.core.DSList;
import org.qubership.automation.configuration.dataset.excel.core.DSLists;
import org.qubership.automation.configuration.dataset.excel.core.ParamsEntryConverter;
import org.qubership.automation.configuration.dataset.excel.core.ReevaluateFormulas;
import org.qubership.automation.configuration.dataset.excel.core.VarsEntryConverter;
import org.qubership.automation.configuration.dataset.excel.impl.DSCell;
import org.qubership.automation.configuration.dataset.excel.tracker.base.AbstractTracker;
import org.qubership.automation.configuration.dataset.excel.tracker.base.Resource;
import org.qubership.automation.itf.configuration.dataset.impl.DataSetListRepository;
import org.qubership.automation.itf.configuration.dataset.impl.excel.ExcelDataSet;
import org.qubership.automation.itf.configuration.dataset.impl.excel.ExcelDataSetList;
import org.qubership.automation.itf.configuration.dataset.impl.excel.ExcelDataSetListsSource;
import org.qubership.automation.itf.core.model.dataset.DataSetList;
import org.qubership.automation.itf.core.model.dataset.DataSetListsSource;
import org.qubership.automation.itf.core.model.dataset.IDataSet;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.startup.StartupErrorCollector;
import org.qubership.automation.itf.core.util.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDataSetListRepository
implements DataSetListRepository {
    public static final char DS_LIST_NATURAL_ID_SEPARATOR = File.separatorChar;
    public static final String DS_FILE_EXTENSION = ".xlsx";
    public static final Joiner COMMA_JOINER = Joiner.on((char)',');
    public static final Path DS_DIR = Paths.get(Config.getConfig().getString("local.storage.directory"), "dataset");
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelDataSetListRepository.class);
    private static final ParamsEntryConverter<String> PARAM_CONV = new ParamsEntryConverter<String>(){

        @Nullable
        public String doParamsEntry(@Nullable DSCell entity, @Nonnull DSCell parameter) {
            if (entity == null) {
                ExcelDataSetListRepository.logWarn("Group", null);
                return null;
            }
            String entityStr = entity.getStringValue();
            if (entityStr.isEmpty()) {
                ExcelDataSetListRepository.logWarn("Group", entity.getCell());
                return null;
            }
            String parameterStr = parameter.getStringValue();
            if (parameterStr.isEmpty()) {
                ExcelDataSetListRepository.logWarn("Param for group " + entityStr, parameter.getCell());
                return null;
            }
            return entityStr + "." + parameterStr;
        }
    };
    private static final Function<Iterator<String>, Set<String>> PARAMS_CONV = Sets::newHashSet;
    private static final VarsEntryConverter<String, Triple<String, String, String>> VAR_CONV = (entity, param, convertedParam, value) -> Triple.of((Object)entity.getStringValue(), (Object)param.getStringValue(), (Object)value.getStringValue());
    private static final Function<Iterator<Triple<String, String, String>>, Collection<Triple<String, String, String>>> VARS_CONV = Lists::newArrayList;
    private final AbstractTracker<String, Set<String>, Collection<Triple<String, String, String>>> tracker = new AbstractTracker<String, Set<String>, Collection<Triple<String, String, String>>>(DS_DIR, 10000L, true){

        @Nonnull
        protected DSLists<String, Set<String>, Collection<Triple<String, String, String>>> build(@Nonnull DataSetBuilder builder) {
            return builder.forAllSheets().forAllDataSets().customParams(PARAM_CONV, PARAMS_CONV).customVars(VAR_CONV, VARS_CONV, ReevaluateFormulas.IN_CONVERTER).build();
        }
    };
    private final Folder<DataSetListsSource> folder;

    public ExcelDataSetListRepository(@Nonnull Folder<DataSetListsSource> folder) {
        this.folder = folder;
    }

    @Nonnull
    private static DataSetListsSource getSource(@Nonnull DataSetList dsList) {
        DataSetListsSource result = dsList.getParent();
        Preconditions.checkNotNull((Object)result, (String)"DataSetList with id {%s} and name {%s} has no parent", (Object)dsList.getID(), (Object)dsList.getName());
        return result;
    }

    private static String getPathName(@Nonnull DataSetList dsList) {
        return ExcelDataSetListRepository.getSource(dsList).getName();
    }

    private static void logWarn(@Nonnull String targetName, @Nullable Cell cell) {
        if (cell != null) {
            LOGGER.debug("{} is empty. Sheet '{}' at [{};{}]", new Object[]{targetName, cell.getSheet().getSheetName(), cell.getRowIndex(), cell.getColumnIndex()});
        } else {
            LOGGER.debug("{} has empty cell", (Object)targetName);
        }
    }

    private static void logListNamesDuplication(@Nonnull DataSetList used, @Nonnull Stream<DataSetList> unused) {
        String sheetName = used.getName();
        String unusedFileNames = COMMA_JOINER.join(unused.map(ExcelDataSetListRepository::getPathName).iterator());
        String allFileNames = COMMA_JOINER.join((Iterable)Lists.newArrayList((Object[])new String[]{ExcelDataSetListRepository.getPathName(used), unusedFileNames}));
        String errorMessage = String.format("Duplication of Data Set Sheet found. Sheet name '%s', Files '%s'. (!) You would be not able to use datasets from file(s) '%s' at sheet '%s' (!)", sheetName, allFileNames, unusedFileNames, sheetName);
        ExcelDataSetListRepository.logDuplication(errorMessage);
    }

    private static void logDuplication(String errorMessage) {
        LOGGER.error(errorMessage);
        StartupErrorCollector.getInstance().addError("Datasets reading", errorMessage, null);
    }

    @Override
    @Nullable
    @Deprecated
    public Collection<DataSetList> getAll() {
        Collection<DataSetListsSource> allSources = this.getAllSources(null);
        if (allSources == null || allSources.isEmpty()) {
            return null;
        }
        return allSources.stream().flatMap(dataSetListsSource -> dataSetListsSource.getDataSetLists().stream()).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public Collection<DataSetListsSource> getAllSources() {
        return this.getAllSources(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Collection<DataSetListsSource> getAllSources(Object projectUuid) {
        Path projectDir = DS_DIR.resolve(String.valueOf(projectUuid));
        if (Files.notExists(projectDir, new LinkOption[0])) {
            LOGGER.info("Directory '{}' for project Excel Data Set does not exist.", (Object)projectDir);
            return null;
        }
        try (Stream<Path> paths = Files.walk(projectDir, new FileVisitOption[0]);){
            List files = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).filter(file -> file.getName().endsWith(DS_FILE_EXTENSION)).collect(Collectors.toList());
            if (files.size() == 0) {
                Collection<DataSetListsSource> collection2 = null;
                return collection2;
            }
            Collection collection = files.stream().map(file -> this.createSource(projectDir.relativize(file.toPath()), projectUuid)).collect(Collectors.toSet());
            return collection;
        }
        catch (IOException e) {
            LOGGER.debug("Error while getting the excel dataset-files");
            return null;
        }
    }

    @Override
    @Nullable
    public Set<IDataSet> getDataSetsWithLabel(@Nonnull DataSetList list, String label, @Nonnull Object projectUuid) {
        return null;
    }

    @Override
    @Nullable
    public DataSetListsSource getSourceByNatureId(@Nonnull Object id, Object projectUuid) {
        Collection<DataSetListsSource> allSources = this.getAllSources(projectUuid);
        if (allSources == null || allSources.isEmpty()) {
            return null;
        }
        return allSources.stream().filter(dataSetListsSource -> Objects.equals(dataSetListsSource.getNaturalId(), id)).findFirst().orElse(null);
    }

    @Override
    public DataSetList getByNatureId(@Nonnull Object id, @Nonnull Object projectUuid) {
        String naturalId = FilenameUtils.normalize((String)Objects.toString(id));
        int separatorIndex = naturalId.indexOf(DS_FILE_EXTENSION + DS_LIST_NATURAL_ID_SEPARATOR);
        if (separatorIndex == -1) {
            return null;
        }
        String filePath = naturalId.substring(0, separatorIndex + DS_FILE_EXTENSION.length());
        String sheetName = naturalId.substring(separatorIndex + DS_FILE_EXTENSION.length() + 1);
        try {
            DataSetListsSource source = this.createSource(Paths.get(filePath, new String[0]), projectUuid);
            return this.create(source, sheetName);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @Override
    @Nullable
    @Deprecated
    public Collection<DataSetList> getByName(String name) {
        Collection<DataSetListsSource> allSources = this.getAllSources();
        if (allSources == null || allSources.isEmpty()) {
            return null;
        }
        Set<DataSetList> found = allSources.stream().flatMap(dataSetListsSource -> dataSetListsSource.getDataSetLists().stream()).filter(dataSetList -> Objects.equals(dataSetList.getName(), name)).collect(Collectors.toSet());
        if (found.isEmpty()) {
            return null;
        }
        if (found.size() == 1) {
            return found;
        }
        DataSetList used = found.iterator().next();
        found.remove(used);
        ExcelDataSetListRepository.logListNamesDuplication(used, found.stream());
        return Collections.singleton(used);
    }

    @Override
    @Nonnull
    public Set<DataSetList> getDataSetLists(@Nonnull DataSetListsSource source) {
        return ((Map)this.resource(source).getResource().get()).keySet().stream().map(dsName -> this.create(source, (String)dsName)).collect(Collectors.toSet());
    }

    @Nonnull
    Set<IDataSet> getDataSets(@Nonnull DataSetList list) {
        return this.getDsList(list).getDataSets().stream().map(ExcelDataSet::new).collect(Collectors.toSet());
    }

    @Nonnull
    Set<String> getVariables(@Nonnull DataSetList list) {
        return (Set)this.getDsList(list).getParameters();
    }

    @Nonnull
    Set<String> getDataSetListsNames(@Nonnull DataSetListsSource source) {
        return ((Map)this.resource(source).getResource().get()).keySet();
    }

    @Nonnull
    DataSetList getDataSetList(@Nonnull DataSetListsSource source, @Nonnull String dataSetListName) {
        return this.create(source, dataSetListName);
    }

    @Nullable
    IDataSet getDataSet(@Nonnull DataSetList list, @Nonnull String name) {
        return this.getDataSets(list).stream().filter(ds -> name.equals(ds.getName())).findAny().orElse(null);
    }

    @Nonnull
    private DataSetListsSource createSource(@Nonnull Path path, @Nonnull Object projectUuid) {
        String relativePath = path.toString();
        return new ExcelDataSetListsSource(this, this.folder, relativePath, relativePath, projectUuid);
    }

    @Nonnull
    private DataSetList create(@Nonnull DataSetListsSource source, @Nonnull String name) {
        String naturalId = source.getName() + DS_LIST_NATURAL_ID_SEPARATOR + name;
        return new ExcelDataSetList(this, source, naturalId, name);
    }

    @Nonnull
    private DSList<String, Set<String>, Collection<Triple<String, String, String>>> getDsList(@Nonnull DataSetList instance) {
        String dsName = instance.getName();
        Resource<Map<String, DSList<String, Set<String>, Collection<Triple<String, String, String>>>>> resource = this.resource(ExcelDataSetListRepository.getSource(instance));
        DSList list = (DSList)((Map)resource.getResource().get()).get(dsName);
        Preconditions.checkNotNull((Object)list, (String)"No ds list with name [%s] found in file [%s]. Available names are: [%s]", (Object)dsName, (Object)resource.getPath(), ((Map)resource.getResource().get()).keySet());
        return list;
    }

    @Nonnull
    private Resource<Map<String, DSList<String, Set<String>, Collection<Triple<String, String, String>>>>> resource(@Nonnull DataSetListsSource source) {
        Path dsPath = DS_DIR.resolve(source.getProjectUuid().toString()).resolve(source.getName());
        Resource resource = this.tracker.getDataSet(dsPath);
        if (resource.getResource().isPresent()) {
            return resource;
        }
        throw new RuntimeException(String.format("Can not read ds list [%s] with status [%s]", resource.getPath(), resource.getStatus()), resource.getLastException().orElse(null));
    }
}

