/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.configuration.utils;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Sets;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AllRefsIterator<T>
extends AbstractIterator<T> {
    private final Deque<Iterator<? extends T>> items = new LinkedList<Iterator<? extends T>>();
    private final Predicate<T> itemsFilter;
    private T lastProcessed;

    public AllRefsIterator(@Nonnull Iterator<? extends T> parents, boolean omitDuplicates) {
        this(parents, omitDuplicates ? new RegularNoCycleGarant() : always -> true);
    }

    protected AllRefsIterator(@Nonnull Iterator<? extends T> parents, Predicate<T> itemsFilter) {
        this.itemsFilter = itemsFilter;
        this.items.add(parents);
    }

    protected T computeNext() {
        if (this.lastProcessed != null) {
            Iterator<T> children = this.getChildren(this.lastProcessed);
            if (children != null) {
                this.items.push(children);
            } else {
                this.backToParents();
            }
            this.lastProcessed = null;
        }
        Iterator<T> temp = this.items.peek();
        while (!temp.hasNext()) {
            this.items.remove();
            this.backToParents();
            temp = this.items.peek();
            if (temp != null) continue;
            return (T)this.endOfData();
        }
        T result = temp.next();
        if (result == null || !this.itemsFilter.test(result)) {
            return this.computeNext();
        }
        this.lastProcessed = result;
        return result;
    }

    @Nullable
    protected abstract Iterator<? extends T> getChildren(@Nonnull T var1);

    protected void backToParents() {
    }

    private static class RegularNoCycleGarant<T>
    implements Predicate<T> {
        private final Set<T> cyclicProtection = Sets.newHashSetWithExpectedSize((int)5);

        private RegularNoCycleGarant() {
        }

        @Override
        public boolean test(@Nullable T t) {
            if (this.cyclicProtection.contains(t)) {
                return false;
            }
            this.cyclicProtection.add(t);
            return true;
        }
    }
}

