/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.configuration.utils;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.automation.itf.configuration.utils.AllRefsIterator;

public class LeafsDetector<T>
extends AllRefsIterator<T> {
    private final LinkedList<T> path = new LinkedList();
    private final Consumer<List<T>> leafsConsumer;
    private final Function<T, Iterator<? extends T>> childrenSup;
    private final Runnable backToParentsCb;

    public LeafsDetector(@Nonnull Iterator<? extends T> parents, @Nonnull Function<T, Iterator<? extends T>> childrenSup, @Nonnull Consumer<List<T>> leafsConsumer, @Nullable Runnable backToParentsCb, @Nullable Predicate<T> itemsFilter) {
        super(parents, itemsFilter == null ? always -> true : itemsFilter);
        this.leafsConsumer = leafsConsumer;
        this.childrenSup = childrenSup;
        this.backToParentsCb = backToParentsCb == null ? Runnables.doNothing() : backToParentsCb;
    }

    @Override
    @Nullable
    protected Iterator<? extends T> getChildren(@Nonnull T parent) {
        Iterator<T> result = this.childrenSup.apply(parent);
        this.path.add(parent);
        if (result == null || !result.hasNext()) {
            this.leafsConsumer.accept(Lists.newArrayList(this.path));
        }
        return result;
    }

    @Override
    protected void backToParents() {
        if (!this.path.isEmpty()) {
            this.path.removeLast();
        }
        this.backToParentsCb.run();
    }
}

