/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.configuration.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.Triple;
import org.qubership.automation.itf.core.util.constants.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class PropertyHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyHelper.class);

    public static boolean meetsMatch(Object object, String property, Match match, Object er) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(object.getClass(), (String)property);
        Class<?> propertyType = propertyDescriptor.getPropertyType();
        Object propertyValue = propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
        switch (match) {
            case EQUALS: {
                return Objects.equals(propertyValue, er);
            }
            case NOT_EQUALS: {
                return !Objects.equals(propertyValue, er);
            }
            case IN: {
                if (propertyValue == null) {
                    return false;
                }
                Set<Object> collection = er instanceof Collection ? (Set<Object>)er : Collections.singleton(er);
                if (propertyType.isArray()) {
                    return collection.containsAll(Arrays.asList((Object[])propertyValue));
                }
                if (Collection.class.isAssignableFrom(propertyType)) {
                    return collection.containsAll((Collection)propertyValue);
                }
                if (Map.class.isAssignableFrom(propertyType)) {
                    return collection.containsAll(((Map)propertyValue).keySet());
                }
                return collection.contains(propertyValue);
            }
        }
        return false;
    }

    public static boolean meetsAllProperties(Object object, Triple<String, Match, ?>[] properties) {
        for (Triple<String, Match, ?> property : properties) {
            boolean meets;
            try {
                meets = PropertyHelper.meetsMatch(object, (String)property.getLeft(), (Match)property.getMiddle(), property.getRight());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Error getting property from object", (Throwable)e);
                meets = false;
            }
            if (meets) continue;
            return false;
        }
        return true;
    }
}

