/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.configuration.dataset.impl.remote;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.json.simple.JSONObject;
import org.qubership.automation.itf.core.model.dataset.IDataSet;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;

public class RemoteDataSet
implements IDataSet {
    private static final String PREFIX = "[Modified Dataset]";
    private final Supplier<JsonContext> contextSup;
    private String name;
    private String dsId;
    private List<String> labels;

    public RemoteDataSet(@Nonnull String name, @Nonnull Supplier<JsonContext> contextSup, String id) {
        this.name = name;
        this.contextSup = contextSup;
        this.dsId = id;
    }

    public RemoteDataSet(@Nonnull String name, @Nonnull Supplier<JsonContext> contextSup, String id, List<String> labels) {
        this.name = name;
        this.contextSup = contextSup;
        this.dsId = id;
        this.labels = labels;
    }

    public JsonContext read(Object projectId) {
        return this.contextSup.get();
    }

    public JsonContext read(@Nonnull JsonContext overriddenValues, Object projectId) {
        JsonContext context = this.read(projectId);
        if (overriddenValues != null && !overriddenValues.isEmpty()) {
            ArrayList keysToDelete = new ArrayList();
            overriddenValues.forEach((key, value) -> {
                Object contextValue = context.get(key);
                if (contextValue != null) {
                    if (value instanceof JSONObject && contextValue instanceof JSONObject) {
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            ((JSONObject)contextValue).put(entry.getKey(), entry.getValue());
                        }
                    } else {
                        context.put(key, value);
                    }
                    keysToDelete.add(key);
                }
            });
            for (Object key2 : keysToDelete) {
                overriddenValues.remove(key2);
            }
        }
        return context;
    }

    public String getIdDs() {
        return this.dsId;
    }

    public String getDsServiceUri() {
        return "";
    }

    public void addModifiedToName(boolean flag) {
        if (flag) {
            this.name = PREFIX + this.name;
        } else if (this.name.startsWith(PREFIX)) {
            this.name = this.name.substring(PREFIX.length());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getLabels() {
        return this.labels;
    }
}

