/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.configuration.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.automation.itf.configuration.utils.LeafsIterator;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;

public class JSONContextUtils {
    public static JsonContext convert(@Nonnull ObjectNode from, @Nonnull ObjectMapper mapper) throws IOException {
        JsonContext to = new JsonContext();
        LeafsIterator<Map.Entry<String, JsonNode>> leafsIter = new LeafsIterator<Map.Entry<String, JsonNode>>(from.fields()){

            @Override
            @Nullable
            protected Iterator<? extends Map.Entry<String, JsonNode>> getChildren(@Nonnull Map.Entry<String, JsonNode> parent) {
                JsonNode parentNode = parent.getValue();
                if (parentNode.isObject()) {
                    return ((ObjectNode)ObjectNode.class.cast(parentNode)).fields();
                }
                return null;
            }
        };
        while (leafsIter.hasNext()) {
            String paramValue;
            List path = (List)leafsIter.next();
            Map.Entry leaf = (Map.Entry)path.get(path.size() - 1);
            Stream pathToLeaf = path.stream().limit(path.size() - 1);
            JsonNode leafNode = (JsonNode)leaf.getValue();
            String paramKey = (String)leaf.getKey();
            List groupNames = pathToLeaf.map(Map.Entry::getKey).collect(Collectors.toList());
            if (leafNode.isValueNode()) {
                paramValue = leafNode.textValue();
                JSONContextUtils.getGroup(groupNames.iterator(), to).put((Object)paramKey, (Object)paramValue);
                continue;
            }
            if (leafNode.isObject() && leafNode.isEmpty()) {
                paramValue = new JsonContext();
                JSONContextUtils.getGroup(groupNames.iterator(), to).put((Object)paramKey, (Object)paramValue);
                continue;
            }
            throw new IOException("Can not accept [" + mapper.writeValueAsString((Object)leaf) + "] parameter value");
        }
        return to;
    }

    private static JsonContext getGroup(@Nonnull Iterator<String> path, @Nonnull JsonContext to) {
        JsonContext result = to;
        while (path.hasNext()) {
            result = JSONContextUtils.getGroup(path.next(), result);
        }
        return result;
    }

    @Nonnull
    private static JsonContext getGroup(@Nonnull String key, @Nonnull JsonContext to) {
        JsonContext validTargetGroup;
        Object targetGroup = to.get((Object)key);
        if (targetGroup == null) {
            validTargetGroup = new JsonContext();
            to.put((Object)key, (Object)validTargetGroup);
        } else {
            validTargetGroup = (JsonContext)JsonContext.class.cast(targetGroup);
        }
        return validTargetGroup;
    }
}

