/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiameterSessionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiameterSessionHolder.class);
    private static final DiameterSessionHolder INSTANCE = new DiameterSessionHolder();
    private final Map<String, Object> sessions = new HashMap<String, Object>();
    private final Set<String> finishedSessions = new HashSet<String>();

    public static DiameterSessionHolder getInstance() {
        return INSTANCE;
    }

    public boolean add(String sessionId, Object contextId) {
        Object absent = this.sessions.putIfAbsent(sessionId, contextId);
        return Objects.isNull(absent);
    }

    public void remove(Object tcContextId) {
        if (!this.sessions.containsValue(tcContextId.toString())) {
            LOGGER.debug("Diameter sessions does not contain context id " + tcContextId);
            return;
        }
        Set<Map.Entry<String, Object>> entries = this.sessions.entrySet();
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Object> entry : entries) {
            if (!entry.getValue().equals(tcContextId.toString())) continue;
            toRemove.add(entry.getKey());
        }
        if (toRemove.isEmpty()) {
            LOGGER.debug("Context id " + tcContextId + " does not contain diameter sessions. Diameter sessions (interceptors) clearing will not be done");
            return;
        }
        this.finishedSessions.addAll(toRemove);
        LOGGER.debug("Context id " + tcContextId + " contains diameter sessions: " + toRemove + " It(they) was marked as finished");
        this.sessions.keySet().removeAll(toRemove);
    }

    public Set<String> getFinished() {
        return this.finishedSessions;
    }

    public void removeFinished(String sessionId) {
        this.finishedSessions.remove(sessionId);
    }

    public void removeSetFinished(Set<String> sessionIds) {
        this.finishedSessions.removeAll(sessionIds);
    }

    public void clearAllFinished() {
        this.finishedSessions.clear();
    }
}

