/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class FlatMapUtil {
    private static final String leadingChar = "";
    private static final String keyDelimiter = ".";
    private static final String arrayElementLeft = "[";
    private static final String arrayElementRight = "]";

    private FlatMapUtil() {
        throw new AssertionError((Object)"No instances for you!");
    }

    public static Map<String, Object> flatten(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(FlatMapUtil::flatten).collect(LinkedHashMap::new, (m, e) -> m.put(leadingChar + (String)e.getKey(), e.getValue()), HashMap::putAll);
    }

    private static Stream<Map.Entry<String, Object>> flatten(Map.Entry<String, Object> entry) {
        if (entry == null) {
            return Stream.empty();
        }
        if (entry.getValue() instanceof Map) {
            return ((Map)entry.getValue()).entrySet().stream().flatMap(e -> FlatMapUtil.flatten(new AbstractMap.SimpleEntry<String, Object>((String)entry.getKey() + keyDelimiter + e.getKey(), e.getValue())));
        }
        if (entry.getValue() instanceof List) {
            List list = (List)entry.getValue();
            return IntStream.range(0, list.size()).mapToObj(i -> new AbstractMap.SimpleEntry((String)entry.getKey() + arrayElementLeft + i + arrayElementRight, list.get(i))).flatMap(FlatMapUtil::flatten);
        }
        return Stream.of(entry);
    }
}

