/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.report.statement;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.report.statement.AbstractSetter;
import org.qubership.automation.itf.core.report.statement.Setter;

public class StatementContext {
    private final StringBuilder query = new StringBuilder();
    private final List<Setter> params = Lists.newArrayList();

    @Nonnull
    public StringBuilder getQuery() {
        return this.query;
    }

    public void addParameter(@Nonnull Setter setter) {
        this.params.add(setter);
    }

    public PreparedStatement prepare(JsonObject json, Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(this.getQuery().toString());
        int i = 1;
        for (Setter s : this.params) {
            i = s.set(json, statement, i);
        }
        return statement;
    }

    public List<String> getParameters() {
        ArrayList params = Lists.newArrayList();
        for (Setter property : this.params) {
            params.add(property.getProperty());
        }
        return params;
    }

    public StatementContext q(String queryPart) {
        this.getQuery().append(queryPart);
        return this;
    }

    public StatementContext asLong(String prop) {
        this.addParameter(new AbstractSetter(prop, -5){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                return element.getAsLong();
            }
        });
        this.getQuery().append("?");
        return this;
    }

    public StatementContext asDate(String prop) {
        this.addParameter(new AbstractSetter(prop, 91){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                long dateLong = element.getAsLong();
                return new Date(dateLong);
            }
        });
        this.getQuery().append("?");
        return this;
    }

    public StatementContext asDataTime(String prop) {
        this.addParameter(new AbstractSetter(prop, 93){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                long dateLong = element.getAsLong();
                return new Timestamp(dateLong);
            }
        });
        this.getQuery().append("?");
        return this;
    }

    public StatementContext asBoolean(String prop) {
        this.addParameter(new AbstractSetter(prop, 16){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                return element.getAsBoolean();
            }
        });
        this.getQuery().append("?");
        return this;
    }

    public StatementContext asString(String prop) {
        this.addParameter(new AbstractSetter(prop, 12){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                return element.getAsString();
            }
        });
        this.getQuery().append("?");
        return this;
    }
}

