/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.qubership.automation.itf.core.model.diameter.DiameterConnectionInfo;
import org.springframework.stereotype.Service;

@Service
public class DiameterConnectionInfoCacheService {
    private final HazelcastInstance hazelcastClient;

    public List<DiameterConnectionInfo> getAllDiameterConnections() {
        ArrayList<DiameterConnectionInfo> connections = new ArrayList<DiameterConnectionInfo>();
        for (Map.Entry connectionEntry : this.getDiameterConnectionCache()) {
            connections.add((DiameterConnectionInfo)connectionEntry.getValue());
        }
        return connections;
    }

    public void put(String distributedCacheId, DiameterConnectionInfo connectionInfo) {
        this.getDiameterConnectionCache().put((Object)distributedCacheId, (Object)connectionInfo);
    }

    public void remove(String distributedCacheId) {
        this.getDiameterConnectionCache().evict((Object)distributedCacheId);
        this.getDiameterConnectionCache().delete((Object)distributedCacheId);
    }

    private IMap<Object, DiameterConnectionInfo> getDiameterConnectionCache() {
        return this.hazelcastClient.getMap("ATP_ITF_DIAMETER_CONNECTION_INFO");
    }

    @ConstructorProperties(value={"hazelcastClient"})
    public DiameterConnectionInfoCacheService(HazelcastInstance hazelcastClient) {
        this.hazelcastClient = hazelcastClient;
    }
}

