/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import org.qubership.automation.itf.core.util.NoBrokerConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFactory.class);
    private ConnectionFactory jndiConnectionFactory;
    private Connection connection;

    private SessionFactory() {
    }

    public ConnectionFactory getJndiConnectionFactory() {
        return this.jndiConnectionFactory;
    }

    public void setJndiConnectionFactory(ConnectionFactory jndiConnectionFactory) {
        this.jndiConnectionFactory = jndiConnectionFactory;
    }

    public Session createSession() {
        if (this.connection == null) {
            this.init();
        }
        if (this.connection != null) {
            try {
                return this.connection.createSession(false, 1);
            }
            catch (JMSException e) {
                LOGGER.error("Session didn't create");
                throw new RuntimeException(e);
            }
        }
        throw new NoBrokerConnectionException("No connection established");
    }

    public void init() {
        try {
            if (this.connection == null) {
                this.connection = this.jndiConnectionFactory.createConnection();
            }
            this.connection.start();
            LOGGER.info("Connection has been started");
        }
        catch (JMSException e) {
            LOGGER.warn("Connection report execution didn't start: {}", (Object)e.getMessage());
        }
    }

    public void destroy() {
        LOGGER.info("Destroy session factory");
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (JMSException e) {
                if (e.getErrorCode().equals("CONNECTION_CLOSED")) {
                    this.connection = null;
                }
                LOGGER.error("Connection report execution didn't stop", (Throwable)e);
            }
        }
    }
}

