/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ByProject;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.LabeledObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.OperationTemplateObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SystemTemplateObjectManager;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;

public class TemplateHelper {
    public static Collection<Template<? extends TemplateProvider>> getByProjectId(BigInteger projectId) {
        Collection templates = ((SearchByProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, SearchByProjectIdManager.class)).getByProjectId(projectId);
        templates.addAll(((SearchByProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(OperationTemplate.class, SearchByProjectIdManager.class)).getByProjectId(projectId));
        return templates;
    }

    public static Template<? extends TemplateProvider> getById(Object id) {
        OperationTemplate template = ((OperationTemplateObjectManager)CoreObjectManager.getInstance().getSpecialManager(OperationTemplate.class, OperationTemplateObjectManager.class)).getByIdOnly(IdConverter.toBigInt((Object)id));
        return template != null ? template : ((SystemTemplateObjectManager)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, SystemTemplateObjectManager.class)).getByIdOnly(IdConverter.toBigInt((Object)id));
    }

    public static Template<? extends TemplateProvider> getById(Object id, String parentClazz) {
        if (StringUtils.isEmpty((CharSequence)parentClazz)) {
            return TemplateHelper.getById(id);
        }
        if (parentClazz.endsWith(".Operation")) {
            return ((OperationTemplateObjectManager)CoreObjectManager.getInstance().getSpecialManager(OperationTemplate.class, OperationTemplateObjectManager.class)).getByIdOnly(IdConverter.toBigInt((Object)id));
        }
        if (parentClazz.endsWith(".System")) {
            return ((SystemTemplateObjectManager)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, SystemTemplateObjectManager.class)).getByIdOnly(IdConverter.toBigInt((Object)id));
        }
        throw new IllegalArgumentException("Unknown parent type of the Template [" + id + "]: " + parentClazz);
    }

    public static Collection<Template<? extends TemplateProvider>> getByPieceOfNameAndProject(String name, BigInteger projectId) {
        Collection templates = ((ByProject)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, ByProject.class)).getByPieceOfNameAndProject(name, (Object)projectId);
        templates.addAll(((ByProject)CoreObjectManager.getInstance().getSpecialManager(OperationTemplate.class, ByProject.class)).getByPieceOfNameAndProject(name, (Object)projectId));
        return templates;
    }

    public static Collection<Template<? extends TemplateProvider>> getByNameAndProjectId(String name, BigInteger projectId) {
        List templates = ((ByProject)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, ByProject.class)).getByNameAndProjectId(name, projectId);
        templates.addAll(((ByProject)CoreObjectManager.getInstance().getSpecialManager(OperationTemplate.class, ByProject.class)).getByNameAndProjectId(name, projectId));
        return templates;
    }

    public static Collection<Template<? extends TemplateProvider>> getFirstPartByNameAndProjectId(String name, BigInteger projectId) {
        List templates = ((ByProject)CoreObjectManager.getInstance().getSpecialManager(OperationTemplate.class, ByProject.class)).getByNameAndProjectId(name, projectId);
        return templates.isEmpty() ? ((ByProject)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, ByProject.class)).getByNameAndProjectId(name, projectId) : templates;
    }

    public static Collection<Template<? extends TemplateProvider>> getByParentNameAndProject(String parentName, BigInteger projectId) {
        Collection templates = ((ByProject)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, ByProject.class)).getByParentNameAndProject(parentName, (Object)projectId);
        templates.addAll(((ByProject)CoreObjectManager.getInstance().getSpecialManager(OperationTemplate.class, ByProject.class)).getByParentNameAndProject(parentName, (Object)projectId));
        return templates;
    }

    public static TemplateProvider getParent(Object parentId) {
        TemplateProvider parent = (TemplateProvider)CoreObjectManager.getInstance().getManager(System.class).getById(parentId);
        if (Objects.isNull(parent)) {
            parent = (TemplateProvider)CoreObjectManager.getInstance().getManager(Operation.class).getById(parentId);
        }
        return parent;
    }

    public static ObjectManager<? extends Template<? extends TemplateProvider>> getManagerByParent(TemplateProvider parent) {
        return parent instanceof System ? CoreObjectManager.getInstance().getManager(SystemTemplate.class) : CoreObjectManager.getInstance().getManager(OperationTemplate.class);
    }

    public static Set<String> getAllLabels(BigInteger projectId) {
        return ((LabeledObjectManager)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, LabeledObjectManager.class)).getAllLabels(projectId);
    }
}

